/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.dom.completion;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.jsxe.dom.completion.ElementDecl;
import net.sourceforge.jsxe.dom.completion.EntityDecl;
import net.sourceforge.jsxe.util.Log;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompletionInfo {
    protected ArrayList elements;
    private HashMap elementHash;
    protected ArrayList entities;
    private HashMap entityHash;
    protected ArrayList elementsAllowedAnywhere;
    private static HashMap completionInfoResources = new HashMap();
    private static HashMap completionInfoNamespaces = new HashMap();
    static /* synthetic */ Class class$net$sourceforge$jsxe$dom$completion$CompletionInfo;
    static /* synthetic */ Class class$net$sourceforge$jsxe$jsXe;

    public CompletionInfo() {
        this(new ArrayList(), new HashMap(), new ArrayList(), new HashMap(), new ArrayList());
        this.addEntity(0, "lt", "<");
        this.addEntity(0, "gt", ">");
        this.addEntity(0, "amp", "&");
        this.addEntity(0, "quot", "\"");
        this.addEntity(0, "apos", "'");
    }

    public CompletionInfo(ArrayList elements, HashMap elementHash, ArrayList entities, HashMap entityHash, ArrayList elementsAllowedAnywhere) {
        this.elements = elements;
        this.elementHash = elementHash;
        this.entities = entities;
        this.entityHash = entityHash;
        this.elementsAllowedAnywhere = elementsAllowedAnywhere;
    }

    public void addEntity(int type, String name, String value) {
        this.addEntity(new EntityDecl(type, name, value));
    }

    public void addEntity(int type, String name, String publicId, String systemId) {
        this.addEntity(new EntityDecl(type, name, publicId, systemId));
    }

    public void addEntity(EntityDecl entity) {
        this.entities.add(entity);
        if (entity.type == 0 && entity.value.length() == 1) {
            Character ch = new Character(entity.value.charAt(0));
            this.entityHash.put(entity.name, ch);
            this.entityHash.put(ch, entity.name);
        }
    }

    public EntityDecl getEntity(String name) {
        Iterator itr = this.entities.iterator();
        while (itr.hasNext()) {
            EntityDecl decl = (EntityDecl)itr.next();
            if (!decl.name.equals(name)) continue;
            return decl;
        }
        return null;
    }

    public List getEntities() {
        return this.entities;
    }

    public Map getEntityHash() {
        return this.entityHash;
    }

    public void addElement(ElementDecl element) {
        this.elementHash.put(element.name, element);
        this.elements.add(element);
    }

    public ElementDecl getElement(String localName) {
        return (ElementDecl)this.elementHash.get(localName);
    }

    public void getAllElements(String prefix, List out) {
        for (int i = 0; i < this.elements.size(); ++i) {
            out.add(((ElementDecl)this.elements.get(i)).withPrefix(prefix));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<element-list>\n\n");
        for (int i = 0; i < this.elements.size(); ++i) {
            buf.append(this.elements.get(i));
            buf.append('\n');
        }
        buf.append("\n</element-list>\n\n<entity-list>\n\n");
        buf.append("<!-- not implemented yet -->\n");
        buf.append("\n</entity-list>");
        return buf.toString();
    }

    public static CompletionInfo getCompletionInfoForNamespace(String namespace) {
        Object obj = completionInfoNamespaces.get(namespace);
        if (obj instanceof String) {
            CompletionInfo info = CompletionInfo.getCompletionInfoFromResource((String)obj);
            completionInfoNamespaces.put(namespace, info);
            return info;
        }
        return (CompletionInfo)obj;
    }

    public static CompletionInfo getCompletionInfoFromResource(String resource) {
        CompletionInfo info = (CompletionInfo)completionInfoResources.get(resource);
        if (info != null) {
            return info;
        }
        Log.log(5, class$net$sourceforge$jsxe$dom$completion$CompletionInfo == null ? (class$net$sourceforge$jsxe$dom$completion$CompletionInfo = CompletionInfo.class$("net.sourceforge.jsxe.dom.completion.CompletionInfo")) : class$net$sourceforge$jsxe$dom$completion$CompletionInfo, "Loading " + resource);
        CompletionInfoHandler handler = new CompletionInfoHandler();
        try {
            SAXParser parser = new SAXParser();
            parser.setFeature("http://apache.org/xml/features/validation/dynamic", false);
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parser.setErrorHandler(handler);
            parser.setEntityResolver(handler);
            parser.setContentHandler(handler);
            URL doc = (class$net$sourceforge$jsxe$jsXe == null ? (class$net$sourceforge$jsxe$jsXe = CompletionInfo.class$("net.sourceforge.jsxe.jsXe")) : class$net$sourceforge$jsxe$jsXe).getResource(resource);
            InputSource source = new InputSource(doc.openStream());
            source.setSystemId(doc.toString());
            parser.parse(source);
        }
        catch (SAXException se) {
            Exception e = se.getException();
            if (e == null) {
                e = se;
            }
            Log.log(9, class$net$sourceforge$jsxe$dom$completion$CompletionInfo == null ? (class$net$sourceforge$jsxe$dom$completion$CompletionInfo = CompletionInfo.class$("net.sourceforge.jsxe.dom.completion.CompletionInfo")) : class$net$sourceforge$jsxe$dom$completion$CompletionInfo, e);
        }
        catch (Exception e) {
            Log.log(9, class$net$sourceforge$jsxe$dom$completion$CompletionInfo == null ? (class$net$sourceforge$jsxe$dom$completion$CompletionInfo = CompletionInfo.class$("net.sourceforge.jsxe.dom.completion.CompletionInfo")) : class$net$sourceforge$jsxe$dom$completion$CompletionInfo, e);
        }
        info = handler.getCompletionInfo();
        completionInfoResources.put(resource, info);
        return info;
    }

    public final Object clone() {
        return new CompletionInfo((ArrayList)this.elements.clone(), (HashMap)this.elementHash.clone(), (ArrayList)this.entities.clone(), (HashMap)this.entityHash.clone(), (ArrayList)this.elementsAllowedAnywhere.clone());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        completionInfoNamespaces.put("http://www.w3.org/1999/XMLSchema", "/net/sourceforge/jsxe/dom/completion/xsd-complete.xml");
        completionInfoNamespaces.put("http://www.w3.org/2001/XMLSchema", "/net/sourceforge/jsxe/dom/completion/xsd-complete.xml");
        completionInfoNamespaces.put("http://www.w3.org/1999/XSL/Transform", "/net/sourceforge/jsxe/dom/completion/xsl-complete.xml");
        completionInfoNamespaces.put("http://www.w3.org/TR/xhtml1/transitional", "/net/sourceforge/jsxe/dom/completion/html-complete.xml");
        completionInfoNamespaces.put("http://www.w3.org/1999/xhtml", "/net/sourceforge/jsxe/dom/completion/html-complete.xml");
        completionInfoNamespaces.put("http://www.w3.org/1999/XSL/Format", "/net/sourceforge/jsxe/dom/completion/fo-complete.xml");
    }

    private static class CompletionInfoHandler
    extends DefaultHandler {
        private CompletionInfo m_m_info = new CompletionInfo();
        private Locator m_m_loc;
        private ElementDecl m_m_element;

        public CompletionInfoHandler() {
            this.m_m_info.addEntity(new EntityDecl(0, "lt", "<"));
            this.m_m_info.addEntity(new EntityDecl(0, "gt", ">"));
            this.m_m_info.addEntity(new EntityDecl(0, "amp", "&"));
            this.m_m_info.addEntity(new EntityDecl(0, "quot", "\""));
            this.m_m_info.addEntity(new EntityDecl(0, "apos", "'"));
        }

        public CompletionInfo getCompletionInfo() {
            return this.m_m_info;
        }

        public void setDocumentLocator(Locator loc) {
            this.m_m_loc = loc;
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            if (!sName.equals("dtd")) {
                if (sName.equals("entity")) {
                    this.m_m_info.addEntity(new EntityDecl(0, attrs.getValue("name"), attrs.getValue("value")));
                } else if (sName.equals("element")) {
                    this.m_m_element = new ElementDecl(this.m_m_info, attrs.getValue("name"), attrs.getValue("content"));
                    this.m_m_info.addElement(this.m_m_element);
                    if ("true".equals(attrs.getValue("anywhere"))) {
                        this.m_m_info.elementsAllowedAnywhere.add(this.m_m_element);
                    }
                } else if (sName.equals("attribute")) {
                    ArrayList<String> values;
                    String name = attrs.getValue("name");
                    String value = attrs.getValue("value");
                    String type = attrs.getValue("type");
                    if (type.startsWith("(")) {
                        values = new ArrayList<String>();
                        StringTokenizer st = new StringTokenizer(type.substring(1, type.length() - 1), "|");
                        while (st.hasMoreTokens()) {
                            values.add(st.nextToken());
                        }
                    } else {
                        values = null;
                    }
                    boolean required = "true".equals(attrs.getValue("required"));
                    this.m_m_element.addAttribute(new ElementDecl.AttributeDecl(name, value, values, type, required));
                }
            }
        }
    }
}

