/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.gui.EnhancedDialog;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.TabbedView;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.util.Log;

public class DirtyFilesDialog
extends EnhancedDialog {
    private TabbedView newTabbedView;
    private JList dirtyFilesJList;
    private DefaultListModel dirtyFilesJListModel;
    private ArrayList newDirtyBuffers;
    private String[] dirtyFiles;
    private JPanel bottomJPanel;
    private JButton cancelJButton;
    private JPanel centerJPanel;
    private JButton discardSelectedJButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane;
    private JButton saveSelectedJButton;
    private JButton selectAllJButton;
    private JLabel topJLabel;
    private JPanel topJPanel;
    private boolean cancelFlag = false;
    private static final String m_geometryName = "dirtyfiles";
    static /* synthetic */ Class class$net$sourceforge$jsxe$gui$DirtyFilesDialog;

    public DirtyFilesDialog(TabbedView parent, ArrayList dirtyBuffers) {
        super(parent, Messages.getMessage("DirtyFilesDialog.Dialog.Title"), true);
        this.newTabbedView = parent;
        this.newDirtyBuffers = dirtyBuffers;
        DirtyFilesDialog.loadGeometry(this, m_geometryName);
        this.dirtyFiles = this.getDirtyFileNames(dirtyBuffers);
        this.dirtyFilesJListModel = new DefaultListModel();
        for (int i = 0; i < this.dirtyFiles.length; ++i) {
            this.dirtyFilesJListModel.addElement(this.dirtyFiles[i]);
        }
        this.dirtyFilesJList = new JList(this.dirtyFilesJListModel);
        this.dirtyFilesJList.setLayoutOrientation(0);
        this.initComponents(this.dirtyFilesJList);
    }

    public void setCancelFlag(boolean newValue) {
        this.cancelFlag = newValue;
    }

    public boolean getCancelFlag() {
        return this.cancelFlag;
    }

    public String[] getDirtyFileNames(ArrayList dirtyBuffers) {
        int size = dirtyBuffers.size();
        String[] dirtyFileNames = new String[size];
        int counter = 0;
        Iterator it = dirtyBuffers.iterator();
        while (it.hasNext()) {
            String filename;
            DocumentBuffer db = (DocumentBuffer)it.next();
            dirtyFileNames[counter] = filename = db.getName();
            ++counter;
        }
        return dirtyFileNames;
    }

    private void initComponents(JList dirtyFiles) {
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        this.topJLabel = new JLabel();
        this.jScrollPane = new JScrollPane(dirtyFiles);
        this.selectAllJButton = new JButton();
        this.saveSelectedJButton = new JButton();
        this.discardSelectedJButton = new JButton();
        this.cancelJButton = new JButton();
        this.topJLabel.setIcon(new ImageIcon((class$net$sourceforge$jsxe$gui$DirtyFilesDialog == null ? (class$net$sourceforge$jsxe$gui$DirtyFilesDialog = DirtyFilesDialog.class$("net.sourceforge.jsxe.gui.DirtyFilesDialog")) : class$net$sourceforge$jsxe$gui$DirtyFilesDialog).getResource("/net/sourceforge/jsxe/icons/metal-Warn.png")));
        this.topJLabel.setText(Messages.getMessage("DirtyFilesDialog.Dialog.Message"));
        this.getContentPane().add((Component)this.topJLabel, "North");
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.selectAllJButton.setText(Messages.getMessage("DirtyFilesDialog.Button.SelectAll.Title"));
        this.selectAllJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirtyFilesDialog.this.selectAllJButtonActionPerformed();
            }
        });
        buttons.add(this.selectAllJButton);
        this.saveSelectedJButton.setText(Messages.getMessage("DirtyFilesDialog.Button.SaveSelected.Title"));
        this.saveSelectedJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirtyFilesDialog.this.saveSelectedJButtonActionPerformed();
            }
        });
        buttons.add(this.saveSelectedJButton);
        this.discardSelectedJButton.setText(Messages.getMessage("DirtyFilesDialog.Button.DiscardSelected.Title"));
        this.discardSelectedJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirtyFilesDialog.this.discardSelectedJButtonActionPerformed();
            }
        });
        buttons.add(this.discardSelectedJButton);
        this.cancelJButton.setText(Messages.getMessage("common.cancel"));
        this.cancelJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirtyFilesDialog.this.cancelJButtonActionPerformed();
            }
        });
        buttons.add(this.cancelJButton);
        buttons.add(Box.createGlue());
        this.getContentPane().add((Component)buttons, "South");
        this.dirtyFilesJList.setSelectedIndex(0);
        this.setVisible(true);
    }

    private void selectAllJButtonActionPerformed() {
        int size = this.dirtyFilesJListModel.getSize();
        int[] selectedIndices = new int[size];
        for (int i = 0; i < size; ++i) {
            selectedIndices[i] = i;
        }
        this.dirtyFilesJList.setSelectedIndices(selectedIndices);
        this.dirtyFilesJList.repaint();
    }

    private void saveSelectedJButtonActionPerformed() {
        try {
            boolean allDiscardFlag = false;
            Object[] selected = this.dirtyFilesJList.getSelectedValues();
            int counter = 0;
            boolean closeSuccessful = true;
            boolean stillOK = true;
            boolean saveAll = selected.length == this.dirtyFiles.length;
            Iterator it = this.newDirtyBuffers.iterator();
            while (it.hasNext() && closeSuccessful) {
                DocumentBuffer db = (DocumentBuffer)it.next();
                String unsavedName = db.getName();
                for (int i = 0; i < selected.length; ++i) {
                    if (selected[i].equals(unsavedName)) {
                        if (db.save(this.newTabbedView)) {
                            closeSuccessful = jsXe.closeDocumentBuffer(this.newTabbedView, db, false);
                            if (closeSuccessful) {
                                this.removeUnsavedFileFromList(unsavedName);
                                this.removeUnsavedFileFromDirtyBufferList(unsavedName);
                            }
                        } else {
                            stillOK = false;
                        }
                    }
                    ++counter;
                }
            }
            if (saveAll) {
                this.ok();
            }
        }
        catch (IOException e) {
            Log.log(9, this, e);
            JOptionPane.showMessageDialog(this.newTabbedView, e.getMessage(), Messages.getMessage("IO.Error.title"), 2);
        }
    }

    private void discardSelectedJButtonActionPerformed() {
        boolean allDiscardFlag = false;
        Object[] selected = this.dirtyFilesJList.getSelectedValues();
        boolean discardAll = selected.length == this.dirtyFiles.length;
        for (int i = 0; i < selected.length; ++i) {
            Iterator it = this.newDirtyBuffers.iterator();
            while (it.hasNext() && selected[i] != null) {
                DocumentBuffer db = (DocumentBuffer)it.next();
                String unsavedName = db.getName();
                if (!selected[i].equals(unsavedName)) continue;
                try {
                    if (!jsXe.closeDocumentBuffer(this.newTabbedView, db, false)) continue;
                    this.removeUnsavedFileFromList(unsavedName);
                    this.removeUnsavedFileFromDirtyBufferList(unsavedName);
                }
                catch (IOException e) {
                    Log.log(9, this, e);
                    JOptionPane.showMessageDialog(this.newTabbedView, e.getMessage(), Messages.getMessage("IO.Error.title"), 2);
                }
            }
        }
        if (discardAll) {
            this.ok();
        }
    }

    private void cancelJButtonActionPerformed() {
        this.setCancelFlag(true);
        this.cancel();
    }

    public void removeUnsavedFileFromList(String name) {
        for (int i = 0; i < this.dirtyFiles.length; ++i) {
            if (this.dirtyFiles[i] == null || !this.dirtyFiles[i].equals(name)) continue;
            try {
                int sizeListModel = this.dirtyFilesJListModel.getSize();
                if (i == sizeListModel) {
                    i = sizeListModel - 1;
                }
                if (sizeListModel != 0) {
                    this.dirtyFilesJListModel.removeElementAt(i);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.log(9, this, e);
            }
            this.dirtyFilesJList.repaint();
            this.jScrollPane.repaint();
        }
    }

    public void removeUnsavedFileFromDirtyBufferList(String unsavedName) {
        ArrayList<String> test = new ArrayList<String>();
        for (int i = 0; i < this.dirtyFiles.length; ++i) {
            if (this.dirtyFiles[i] == null || this.dirtyFiles[i].equals(unsavedName)) continue;
            test.add(this.dirtyFiles[i]);
        }
        Object[] testArrayVersion = test.toArray();
        String[] tempArray = new String[test.size()];
        for (int i = 0; i < test.size(); ++i) {
            tempArray[i] = (String)testArrayVersion[i];
        }
        this.dirtyFiles = tempArray;
    }

    public void populateDirtyFileList(ArrayList dirtyList, DefaultListModel model) {
        Iterator it = dirtyList.iterator();
        while (it.hasNext()) {
            String filename = (String)it.next();
            model.addElement(filename);
        }
    }

    public void ok() {
        this.cancel();
    }

    public void cancel() {
        DirtyFilesDialog.saveGeometry(this, m_geometryName);
        this.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

