/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.sourceforge.jsxe.OperatingSystem;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.TabbedView;
import net.sourceforge.jsxe.gui.VariableGridLayout;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;

public class GUIUtilities {
    private static String defaultIconPath;
    private static String iconPath;
    private static Hashtable icons;
    static /* synthetic */ Class class$net$sourceforge$jsxe$gui$GUIUtilities;
    static /* synthetic */ Class class$net$sourceforge$jsxe$gui$TabbedView;

    public static void setIconPath(String iconPath) {
        GUIUtilities.iconPath = iconPath;
        if (icons != null) {
            icons.clear();
        }
    }

    public static Icon loadIcon(String iconName) {
        ImageIcon icon;
        if (icons == null) {
            icons = new Hashtable();
        }
        if ((icon = (ImageIcon)icons.get(iconName)) != null) {
            return icon;
        }
        if (MiscUtilities.isURL(iconName)) {
            icon = new ImageIcon(iconName.substring(5));
        } else {
            try {
                URL url = (class$net$sourceforge$jsxe$gui$GUIUtilities == null ? (class$net$sourceforge$jsxe$gui$GUIUtilities = GUIUtilities.class$("net.sourceforge.jsxe.gui.GUIUtilities")) : class$net$sourceforge$jsxe$gui$GUIUtilities).getResource(iconPath + iconName);
                icon = new ImageIcon(url);
            }
            catch (Exception e) {
                try {
                    URL url = (class$net$sourceforge$jsxe$gui$GUIUtilities == null ? (class$net$sourceforge$jsxe$gui$GUIUtilities = GUIUtilities.class$("net.sourceforge.jsxe.gui.GUIUtilities")) : class$net$sourceforge$jsxe$gui$GUIUtilities).getResource(defaultIconPath + iconName);
                    icon = new ImageIcon(url);
                }
                catch (Exception ex) {
                    Log.log(9, class$net$sourceforge$jsxe$gui$GUIUtilities == null ? (class$net$sourceforge$jsxe$gui$GUIUtilities = GUIUtilities.class$("net.sourceforge.jsxe.gui.GUIUtilities")) : class$net$sourceforge$jsxe$gui$GUIUtilities, "Icon not found: " + iconName);
                    Log.log(9, class$net$sourceforge$jsxe$gui$GUIUtilities == null ? (class$net$sourceforge$jsxe$gui$GUIUtilities = GUIUtilities.class$("net.sourceforge.jsxe.gui.GUIUtilities")) : class$net$sourceforge$jsxe$gui$GUIUtilities, ex);
                    return null;
                }
            }
        }
        icons.put(iconName, icon);
        return icon;
    }

    public static void message(Component comp, String name, Object[] args) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(comp, Messages.getMessage(name.concat(".message"), args), Messages.getMessage(name.concat(".title"), args), 1);
    }

    public static void error(Component comp, String name, Object[] args) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(comp, Messages.getMessage(name.concat(".message"), args), Messages.getMessage(name.concat(".title"), args), 0);
    }

    public static String input(Component comp, String name, Object def) {
        return GUIUtilities.input(comp, name, null, def);
    }

    public static String inputProperty(Component comp, String name, String def) {
        return GUIUtilities.inputProperty(comp, name, null, def);
    }

    public static String input(Component comp, String name, Object[] args, Object def) {
        GUIUtilities.hideSplashScreen();
        String retVal = (String)JOptionPane.showInputDialog(comp, Messages.getMessage(name.concat(".message"), args), Messages.getMessage(name.concat(".title")), 3, null, null, def);
        return retVal;
    }

    public static String inputProperty(Component comp, String name, Object[] args, String def) {
        GUIUtilities.hideSplashScreen();
        String retVal = (String)JOptionPane.showInputDialog(comp, Messages.getMessage(name.concat(".message"), args), Messages.getMessage(name.concat(".title")), 3, null, null, jsXe.getProperty(def));
        if (retVal != null) {
            jsXe.setProperty(def, retVal);
        }
        return retVal;
    }

    public static int confirm(Component comp, String name, Object[] args, int buttons, int type) {
        GUIUtilities.hideSplashScreen();
        return JOptionPane.showConfirmDialog(comp, Messages.getMessage(name + ".message", args), Messages.getMessage(name + ".title"), buttons, type);
    }

    public static Color parseColor(String name) {
        return GUIUtilities.parseColor(name, Color.black);
    }

    public static Color parseColor(String name, Color defaultColor) {
        if (name == null) {
            return defaultColor;
        }
        if (name.startsWith("#")) {
            try {
                return Color.decode(name);
            }
            catch (NumberFormatException nf) {
                return defaultColor;
            }
        }
        if ("red".equals(name)) {
            return Color.red;
        }
        if ("green".equals(name)) {
            return Color.green;
        }
        if ("blue".equals(name)) {
            return Color.blue;
        }
        if ("yellow".equals(name)) {
            return Color.yellow;
        }
        if ("orange".equals(name)) {
            return Color.orange;
        }
        if ("white".equals(name)) {
            return Color.white;
        }
        if ("lightGray".equals(name)) {
            return Color.lightGray;
        }
        if ("gray".equals(name)) {
            return Color.gray;
        }
        if ("darkGray".equals(name)) {
            return Color.darkGray;
        }
        if ("black".equals(name)) {
            return Color.black;
        }
        if ("cyan".equals(name)) {
            return Color.cyan;
        }
        if ("magenta".equals(name)) {
            return Color.magenta;
        }
        if ("pink".equals(name)) {
            return Color.pink;
        }
        return defaultColor;
    }

    public static String getColorHexString(Color c) {
        String colString = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        return "#000000".substring(0, 7 - colString.length()).concat(colString);
    }

    public static void loadGeometry(Window win, String name) {
        Dimension size = win.getSize();
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Rectangle gcbounds = gd.getDefaultConfiguration().getBounds();
        int x = gcbounds.x;
        int y = gcbounds.y;
        int width = jsXe.getIntegerProperty(name + ".width", size.width);
        int height = jsXe.getIntegerProperty(name + ".height", size.height);
        Container parent = win.getParent();
        if (parent == null) {
            x += (gcbounds.width - width) / 2;
            y += (gcbounds.height - height) / 2;
        } else {
            Rectangle bounds = parent.getBounds();
            x += bounds.x + (bounds.width - width) / 2;
            y += bounds.y + (bounds.height - height) / 2;
        }
        x = jsXe.getIntegerProperty(name + ".x", x);
        y = jsXe.getIntegerProperty(name + ".y", y);
        int extState = jsXe.getIntegerProperty(name + ".extendedState", 0);
        Rectangle desired = new Rectangle(x, y, width, height);
        GUIUtilities.adjustForScreenBounds(desired);
        win.setBounds(desired);
        if (win instanceof Frame) {
            ((Frame)win).setExtendedState(extState);
        }
    }

    public static void adjustForScreenBounds(Rectangle desired) {
        Rectangle osbounds = OperatingSystem.getScreenBounds(desired);
        if (desired.x < osbounds.x || desired.x + desired.width > desired.x + osbounds.width) {
            if (desired.width > osbounds.width) {
                desired.width = osbounds.width;
            }
            desired.x = (osbounds.width - desired.width) / 2;
        }
        if (desired.y < osbounds.y || desired.y + desired.height > osbounds.y + osbounds.height) {
            if (desired.height >= osbounds.height) {
                desired.height = osbounds.height;
            }
            desired.y = (osbounds.height - desired.height) / 2;
        }
    }

    public static void saveGeometry(Window win, String name) {
        if (win instanceof Frame) {
            jsXe.setIntegerProperty(name + ".extendedState", ((Frame)win).getExtendedState());
        }
        Rectangle bounds = win.getBounds();
        jsXe.setIntegerProperty(name + ".x", bounds.x);
        jsXe.setIntegerProperty(name + ".y", bounds.y);
        jsXe.setIntegerProperty(name + ".width", bounds.width);
        jsXe.setIntegerProperty(name + ".height", bounds.height);
    }

    public static void hideSplashScreen() {
    }

    public static JComponent createMultilineLabel(String str) {
        int index;
        JPanel panel = new JPanel(new VariableGridLayout(2, 1, 1, 1));
        int lastOffset = 0;
        while ((index = str.indexOf(10, lastOffset)) != -1) {
            panel.add(new JLabel(str.substring(lastOffset, index)));
            lastOffset = index + 1;
        }
        if (lastOffset != str.length()) {
            panel.add(new JLabel(str.substring(lastOffset)));
        }
        return panel;
    }

    public static void requestFocus(final Window win, final Component comp) {
        win.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        1.access$000(this.this$0).requestFocus();
                    }
                });
                win.removeWindowListener(this);
            }

            static /* synthetic */ Component access$000(1 x0) {
                return x0.comp;
            }
        });
    }

    public static boolean isPopupTrigger(MouseEvent evt) {
        return GUIUtilities.isRightButton(evt.getModifiers());
    }

    public static boolean isMiddleButton(int modifiers) {
        if (OperatingSystem.isMacOS()) {
            if ((modifiers & 0x10) != 0) {
                return (modifiers & 8) != 0;
            }
            return (modifiers & 4) != 0;
        }
        return (modifiers & 8) != 0;
    }

    public static boolean isRightButton(int modifiers) {
        if (OperatingSystem.isMacOS()) {
            if ((modifiers & 0x10) != 0) {
                return (modifiers & 2) != 0;
            }
            return (modifiers & 8) != 0;
        }
        return (modifiers & 4) != 0;
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y) {
        GUIUtilities.showPopupMenu(popup, comp, x, y, true);
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y, boolean point) {
        Component win;
        int offsetX = 0;
        int offsetY = 0;
        int extraOffset = point ? 1 : 0;
        for (win = comp; !(win instanceof Window) && win != null; win = win.getParent()) {
            offsetX += win.getX();
            offsetY += win.getY();
        }
        if (win != null) {
            Dimension size = popup.getPreferredSize();
            Rectangle screenSize = win.getGraphicsConfiguration().getBounds();
            x = x + offsetX + size.width + win.getX() > screenSize.width && x + offsetX + win.getX() >= size.width ? (point ? (x -= size.width + extraOffset) : win.getWidth() - size.width - offsetX + extraOffset) : (x += extraOffset);
            y = y + offsetY + size.height + win.getY() > screenSize.height && y + offsetY + win.getY() >= size.height ? (point ? win.getHeight() - size.height - offsetY + extraOffset : -size.height - 1) : (y += extraOffset);
            popup.show(comp, x, y);
        } else {
            popup.show(comp, x + extraOffset, y + extraOffset);
        }
    }

    public static boolean isAncestorOf(Component comp1, Component comp2) {
        while (comp2 != null) {
            if (comp1 == comp2) {
                return true;
            }
            comp2 = comp2.getParent();
        }
        return false;
    }

    public static JDialog getParentDialog(Component c) {
        Container p;
        for (p = c.getParent(); p != null && !(p instanceof JDialog); p = p.getParent()) {
        }
        return p instanceof JDialog ? (JDialog)p : null;
    }

    public static Component getComponentParent(Component comp, Class clazz) {
        while (comp != null) {
            Component real;
            if (comp instanceof JComponent && (real = (Component)((JComponent)comp).getClientProperty("KORTE_REAL_FRAME")) != null) {
                comp = real;
            }
            if (comp.getClass().equals(clazz)) {
                return comp;
            }
            if (comp instanceof JPopupMenu) {
                comp = ((JPopupMenu)comp).getInvoker();
                continue;
            }
            comp = comp.getParent();
        }
        return null;
    }

    public static TabbedView getView(Component comp) {
        return (TabbedView)GUIUtilities.getComponentParent(comp, class$net$sourceforge$jsxe$gui$TabbedView == null ? (class$net$sourceforge$jsxe$gui$TabbedView = GUIUtilities.class$("net.sourceforge.jsxe.gui.TabbedView")) : class$net$sourceforge$jsxe$gui$TabbedView);
    }

    private GUIUtilities() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        iconPath = defaultIconPath = "/net/sourceforge/jsxe/icons/";
    }

    static class UnixWorkaround {
        Window win;
        String name;
        Rectangle desired;
        Rectangle required;
        long start;
        boolean windowOpened;

        UnixWorkaround(Window win, String name, Rectangle desired, int extState) {
            this.win = win;
            this.name = name;
            this.desired = desired;
            int adjust_x = jsXe.getIntegerProperty(name + ".dx", 0);
            int adjust_y = jsXe.getIntegerProperty(name + ".dy", 0);
            int adjust_width = jsXe.getIntegerProperty(name + ".d-width", 0);
            int adjust_height = jsXe.getIntegerProperty(name + ".d-height", 0);
            this.required = new Rectangle(desired.x - adjust_x, desired.y - adjust_y, desired.width - adjust_width, desired.height - adjust_height);
            Log.log(1, class$net$sourceforge$jsxe$gui$GUIUtilities == null ? (class$net$sourceforge$jsxe$gui$GUIUtilities = GUIUtilities.class$("net.sourceforge.jsxe.gui.GUIUtilities")) : class$net$sourceforge$jsxe$gui$GUIUtilities, "Window " + name + ": desired geometry is " + desired);
            Log.log(1, class$net$sourceforge$jsxe$gui$GUIUtilities == null ? (class$net$sourceforge$jsxe$gui$GUIUtilities = GUIUtilities.class$("net.sourceforge.jsxe.gui.GUIUtilities")) : class$net$sourceforge$jsxe$gui$GUIUtilities, "Window " + name + ": setting geometry to " + this.required);
            this.start = System.currentTimeMillis();
            win.setBounds(this.required);
            if (win instanceof Frame) {
                ((Frame)win).setExtendedState(extState);
            }
            win.addComponentListener(new ComponentHandler());
            win.addWindowListener(new WindowHandler());
        }

        class WindowHandler
        extends WindowAdapter {
            WindowHandler() {
            }

            public void windowOpened(WindowEvent evt) {
                UnixWorkaround.this.windowOpened = true;
                Rectangle r = UnixWorkaround.this.win.getBounds();
                Log.log(1, class$net$sourceforge$jsxe$gui$GUIUtilities == null ? (class$net$sourceforge$jsxe$gui$GUIUtilities = GUIUtilities.class$("net.sourceforge.jsxe.gui.GUIUtilities")) : class$net$sourceforge$jsxe$gui$GUIUtilities, "Window " + UnixWorkaround.this.name + ": bounds after opening: " + r);
                jsXe.setIntegerProperty(UnixWorkaround.this.name + ".dx", r.x - UnixWorkaround.this.required.x);
                jsXe.setIntegerProperty(UnixWorkaround.this.name + ".dy", r.y - UnixWorkaround.this.required.y);
                jsXe.setIntegerProperty(UnixWorkaround.this.name + ".d-width", r.width - UnixWorkaround.this.required.width);
                jsXe.setIntegerProperty(UnixWorkaround.this.name + ".d-height", r.height - UnixWorkaround.this.required.height);
                UnixWorkaround.this.win.removeWindowListener(this);
            }
        }

        class ComponentHandler
        extends ComponentAdapter {
            ComponentHandler() {
            }

            public void componentMoved(ComponentEvent evt) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle r = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && r.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!r.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, class$net$sourceforge$jsxe$gui$GUIUtilities == null ? (class$net$sourceforge$jsxe$gui$GUIUtilities = GUIUtilities.class$("net.sourceforge.jsxe.gui.GUIUtilities")) : class$net$sourceforge$jsxe$gui$GUIUtilities, "Window resize blocked: " + UnixWorkaround.this.win.getBounds());
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }

            public void componentResized(ComponentEvent evt) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle r = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && r.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!r.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, class$net$sourceforge$jsxe$gui$GUIUtilities == null ? (class$net$sourceforge$jsxe$gui$GUIUtilities = GUIUtilities.class$("net.sourceforge.jsxe.gui.GUIUtilities")) : class$net$sourceforge$jsxe$gui$GUIUtilities, "Window resize blocked: " + UnixWorkaround.this.win.getBounds());
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }
        }
    }
}

