/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import net.sourceforge.jsxe.OperatingSystem;
import net.sourceforge.jsxe.gui.KeyEventWorkaround;
import net.sourceforge.jsxe.util.Log;

public class KeyEventTranslator {
    static int c;
    static int a;
    static int m;
    static int s;
    private static Map transMap;
    static /* synthetic */ Class class$net$sourceforge$jsxe$gui$KeyEventTranslator;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public static void addTranslation(Key key1, Key key2) {
        transMap.put(key1, key2);
    }

    public static Key translateKeyEvent(KeyEvent evt) {
        int modifiers = evt.getModifiers();
        Key returnValue = null;
        switch (evt.getID()) {
            case 401: {
                int keyCode = evt.getKeyCode();
                if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
                    if (OperatingSystem.isMacOS()) {
                        return null;
                    }
                    returnValue = new Key(modifiers, 0, Character.toLowerCase((char)keyCode));
                    break;
                }
                if (keyCode == 9) {
                    evt.consume();
                    returnValue = new Key(modifiers, keyCode, '\u0000');
                    break;
                }
                if (keyCode == 32) {
                    if ((modifiers & 0xFFFFFFFE) == 0) {
                        returnValue = null;
                        break;
                    }
                    returnValue = new Key(modifiers, 0, ' ');
                    break;
                }
                returnValue = new Key(modifiers, keyCode, '\u0000');
                break;
            }
            case 400: {
                char ch = evt.getKeyChar();
                switch (ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': {
                        return null;
                    }
                    case ' ': {
                        if ((modifiers & 0xFFFFFFFE) == 0) break;
                        return null;
                    }
                }
                int ignoreMods = OperatingSystem.isMacOS() ? 41 : 33;
                if ((modifiers & 0x20) == 0 && evt.getWhen() - KeyEventWorkaround.lastKeyTime < 750L && (KeyEventWorkaround.modifiers & ~ignoreMods) != 0) {
                    if (OperatingSystem.isMacOS()) {
                        returnValue = new Key(modifiers, 0, ch);
                        break;
                    }
                    return null;
                }
                if (ch == ' ') {
                    returnValue = new Key(modifiers, 0, ch);
                    break;
                }
                returnValue = new Key(0, 0, ch);
                break;
            }
            default: {
                return null;
            }
        }
        Key trans = (Key)transMap.get(returnValue);
        if (trans == null) {
            return returnValue;
        }
        return trans;
    }

    public static int parseModifiers(String keyStroke) {
        int modifiers = 0;
        int index = keyStroke.indexOf(43);
        if (index != -1) {
            block6: for (int i = 0; i < index; ++i) {
                switch (Character.toUpperCase(keyStroke.charAt(i))) {
                    case 'A': {
                        modifiers |= a;
                        continue block6;
                    }
                    case 'C': {
                        modifiers |= c;
                        continue block6;
                    }
                    case 'M': {
                        modifiers |= m;
                        continue block6;
                    }
                    case 'S': {
                        modifiers |= s;
                    }
                }
            }
        }
        return modifiers;
    }

    public static Key parseKey(String keyStroke) {
        int ch;
        if (keyStroke == null) {
            return null;
        }
        int modifiers = KeyEventTranslator.parseModifiers(keyStroke);
        int index = keyStroke.indexOf(43);
        String key = keyStroke.substring(index + 1);
        if (key.length() == 1) {
            return new Key(modifiers, 0, key.charAt(0));
        }
        if (key.length() == 0) {
            Log.log(9, class$net$sourceforge$jsxe$gui$KeyEventTranslator == null ? (class$net$sourceforge$jsxe$gui$KeyEventTranslator = KeyEventTranslator.class$("net.sourceforge.jsxe.gui.KeyEventTranslator")) : class$net$sourceforge$jsxe$gui$KeyEventTranslator, "Invalid key stroke: " + keyStroke);
            return null;
        }
        if (key.equals("SPACE")) {
            return new Key(modifiers, 0, ' ');
        }
        try {
            ch = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = KeyEventTranslator.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField("VK_".concat(key)).getInt(null);
        }
        catch (Exception e) {
            Log.log(9, class$net$sourceforge$jsxe$gui$KeyEventTranslator == null ? (class$net$sourceforge$jsxe$gui$KeyEventTranslator = KeyEventTranslator.class$("net.sourceforge.jsxe.gui.KeyEventTranslator")) : class$net$sourceforge$jsxe$gui$KeyEventTranslator, "Invalid key stroke: " + keyStroke);
            return null;
        }
        return new Key(modifiers, ch, '\u0000');
    }

    public static KeyStroke getKeyStroke(String keyStroke) {
        Key key = KeyEventTranslator.parseKey(keyStroke);
        if (key.input != '\u0000') {
            return KeyStroke.getKeyStroke(new Character(key.input), key.modifiers);
        }
        return KeyStroke.getKeyStroke(key.key, key.modifiers);
    }

    public static void setModifierMapping(int c, int a, int m, int s) {
        int duplicateMapping = c & a | c & m | c & s | a & m | a & s | m & s;
        if ((duplicateMapping & 2) != 0) {
            throw new IllegalArgumentException("CTRL is mapped to more than one modifier");
        }
        if ((duplicateMapping & 8) != 0) {
            throw new IllegalArgumentException("ALT is mapped to more than one modifier");
        }
        if ((duplicateMapping & 4) != 0) {
            throw new IllegalArgumentException("META is mapped to more than one modifier");
        }
        if ((duplicateMapping & 1) != 0) {
            throw new IllegalArgumentException("SHIFT is mapped to more than one modifier");
        }
        KeyEventTranslator.c = c;
        KeyEventTranslator.a = a;
        KeyEventTranslator.m = m;
        KeyEventTranslator.s = s;
    }

    public static char getSymbolicModifierName(int mod) {
        if ((mod & c) != 0) {
            return 'C';
        }
        if ((mod & a) != 0) {
            return 'A';
        }
        if ((mod & m) != 0) {
            return 'M';
        }
        if ((mod & s) != 0) {
            return 'S';
        }
        return '\u0000';
    }

    public static String modifiersToString(int mods) {
        StringBuffer buf = null;
        if ((mods & 2) != 0) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if ((mods & 8) != 0) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if ((mods & 4) != 0) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if ((mods & 1) != 0) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        if (buf == null) {
            return null;
        }
        return buf.toString();
    }

    public static String getModifierString(InputEvent evt) {
        StringBuffer buf = new StringBuffer();
        if (evt.isControlDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if (evt.isAltDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if (evt.isMetaDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if (evt.isShiftDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        transMap = new HashMap();
        if (OperatingSystem.isMacOS()) {
            KeyEventTranslator.setModifierMapping(4, 2, 8, 1);
        } else {
            KeyEventTranslator.setModifierMapping(2, 8, 4, 1);
        }
    }

    public static class Key {
        public int modifiers;
        public int key;
        public char input;

        public Key(int modifiers, int key, char input) {
            this.modifiers = modifiers;
            this.key = key;
            this.input = input;
        }

        public int hashCode() {
            return this.key + this.input;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                if (this.modifiers == k.modifiers && this.key == k.key && this.input == k.input) {
                    return true;
                }
            }
            return false;
        }

        public String getModString() {
            return KeyEventTranslator.modifiersToString(this.modifiers);
        }

        public String getInternalShortcut() {
            StringBuffer keyString = new StringBuffer();
            String modString = KeyEventTranslator.modifiersToString(this.modifiers);
            if (modString != null) {
                keyString.append(modString).append('+');
            }
            if (this.input == ' ') {
                keyString.append("SPACE");
            } else if (this.input != '\u0000') {
                keyString.append(this.input);
            } else {
                String symbolicName = this.getSymbolicName(this.key);
                if (symbolicName == null) {
                    return null;
                }
                keyString.append(symbolicName);
            }
            return keyString.toString();
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            String text = KeyEvent.getKeyModifiersText(this.modifiers);
            if (text != null && text.length() != 0) {
                str.append(text).append(" ");
            }
            if (this.input != '\u0000') {
                if (this.input == ' ') {
                    str.append(KeyEvent.getKeyText(32));
                } else {
                    str.append(this.input);
                }
            } else {
                str.append(KeyEvent.getKeyText(this.key));
            }
            return str.toString();
        }

        private String getSymbolicName(int keyCode) {
            if (keyCode == 0) {
                return null;
            }
            if (keyCode >= 65 && keyCode <= 90) {
                return String.valueOf(Character.toLowerCase((char)keyCode));
            }
            try {
                Field[] fields = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = KeyEventTranslator.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    String name = field.getName();
                    if (!name.startsWith("VK_") || field.getInt(null) != keyCode) continue;
                    return name.substring(3);
                }
            }
            catch (Exception e) {
                Log.log(9, this, e);
            }
            return null;
        }
    }
}

