/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class VariableGridLayout
implements LayoutManager2,
Serializable {
    public static final int FIXED_NUM_ROWS = 1;
    public static final int FIXED_NUM_COLUMNS = 2;
    private int mode;
    private int size;
    private int hgap;
    private int vgap;
    private transient int nrows = -1;
    private transient int ncols = -1;
    private transient int[] row_heights = null;
    private transient int[] col_widths = null;

    public VariableGridLayout(int mode, int size, int hgap, int vgap) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("illegal mode; value is " + mode);
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size cannot be zero or less; value is " + size);
        }
        if (hgap < 0) {
            throw new IllegalArgumentException("hgap cannot be negative; value is " + hgap);
        }
        if (vgap < 0) {
            throw new IllegalArgumentException("vgap cannot be negative; value is " + vgap);
        }
        this.mode = mode;
        this.size = size;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public VariableGridLayout(int mode, int size) {
        this(mode, size, 0, 0);
    }

    public VariableGridLayout() {
        this(1, 1, 0, 0);
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void addLayoutComponent(Component component, Object constraints) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 2);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 0);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.update(parent);
            int ncomponents = parent.getComponentCount();
            if (ncomponents == 0) {
                return;
            }
            int total_height = 0;
            int i = 0;
            for (int r = 0; r < this.nrows; ++r) {
                for (int c = 0; c < this.ncols && i < ncomponents; ++c, ++i) {
                    Dimension d = parent.getComponent(i).getPreferredSize();
                    this.row_heights[r] = Math.max(this.row_heights[r], d.height);
                    this.col_widths[c] = Math.max(this.col_widths[c], d.width);
                }
                total_height += this.row_heights[r];
            }
            int total_width = 0;
            for (int c = 0; c < this.ncols; ++c) {
                total_width += this.col_widths[c];
            }
            Dimension parent_size = parent.getSize();
            Insets insets = parent.getInsets();
            int free_height = parent_size.height - insets.top - insets.bottom - (this.nrows - 1) * this.vgap;
            int free_width = parent_size.width - insets.left - insets.right - (this.ncols - 1) * this.hgap;
            if (total_height != free_height) {
                double dy = (double)free_height / (double)total_height;
                for (int r = 0; r < this.nrows; ++r) {
                    this.row_heights[r] = (int)((double)this.row_heights[r] * dy);
                }
            }
            if (total_width != free_width) {
                double dx = (double)free_width / (double)total_width;
                for (int c = 0; c < this.ncols; ++c) {
                    this.col_widths[c] = (int)((double)this.col_widths[c] * dx);
                }
            }
            int y = insets.top;
            int i2 = 0;
            for (int r = 0; r < this.nrows; ++r) {
                int c = 0;
                int x = insets.left;
                while (c < this.ncols) {
                    if (i2 < ncomponents) {
                        parent.getComponent(i2).setBounds(x, y, this.col_widths[c], this.row_heights[r]);
                    }
                    x += this.col_widths[c] + this.hgap;
                    ++c;
                    ++i2;
                }
                y += this.row_heights[r] + this.vgap;
            }
        }
    }

    public void invalidateLayout(Container container) {
    }

    public String toString() {
        return this.getClass().getName() + "[mode=" + this.mode + ",size=" + this.size + ",hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container parent, int which) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.update(parent);
            int ncomponents = parent.getComponentCount();
            int h = 0;
            int w = 0;
            int i = 0;
            for (int r = 0; r < this.nrows; ++r) {
                int row_height = 0;
                block12: for (int c = 0; c < this.ncols && i < ncomponents; ++c, ++i) {
                    switch (which) {
                        case 0: {
                            row_height = Math.max(row_height, parent.getComponent((int)i).getMinimumSize().height);
                            continue block12;
                        }
                        case 1: {
                            row_height = Math.max(row_height, parent.getComponent((int)i).getMaximumSize().height);
                            continue block12;
                        }
                        default: {
                            row_height = Math.max(row_height, parent.getComponent((int)i).getPreferredSize().height);
                        }
                    }
                }
                h += row_height;
            }
            for (int c = 0; c < this.ncols; ++c) {
                int i2;
                int col_width = 0;
                block14: for (int r = 0; r < this.nrows && (i2 = r * this.ncols + c) < ncomponents; ++r) {
                    switch (which) {
                        case 0: {
                            col_width = Math.max(col_width, parent.getComponent((int)i2).getMinimumSize().width);
                            continue block14;
                        }
                        case 1: {
                            col_width = Math.max(col_width, parent.getComponent((int)i2).getMaximumSize().width);
                            continue block14;
                        }
                        default: {
                            col_width = Math.max(col_width, parent.getComponent((int)i2).getPreferredSize().width);
                        }
                    }
                }
                w += col_width;
            }
            Insets insets = parent.getInsets();
            return new Dimension(w + insets.left + insets.right + (this.ncols - 1) * this.hgap, h + insets.top + insets.bottom + (this.nrows - 1) * this.vgap);
        }
    }

    private void update(Container container) {
        int ncomponents = container.getComponentCount();
        int old_nrows = this.nrows;
        int old_ncols = this.ncols;
        if (this.mode == 1) {
            this.nrows = this.size;
            this.ncols = (ncomponents + this.nrows - 1) / this.nrows;
        } else {
            this.ncols = this.size;
            this.nrows = (ncomponents + this.ncols - 1) / this.ncols;
        }
        if (old_nrows != this.nrows) {
            this.row_heights = new int[this.nrows];
        }
        if (old_ncols != this.ncols) {
            this.col_widths = new int[this.ncols];
        }
    }
}

