/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.options;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.jsxe.ActionManager;
import net.sourceforge.jsxe.ActionSet;
import net.sourceforge.jsxe.gui.GUIUtilities;
import net.sourceforge.jsxe.gui.GrabKeyDialog;
import net.sourceforge.jsxe.gui.KeyEventTranslator;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.options.AbstractOptionPane;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;

public class ShortcutsOptionPane
extends AbstractOptionPane {
    private ActionSetTableModel m_currentModel;
    private Vector m_models;
    private JComboBox m_setsComboBox;
    private JTable m_keyTable;

    public ShortcutsOptionPane() {
        super("shortcuts");
    }

    public String getTitle() {
        return Messages.getMessage("Shortcuts.Options.Title");
    }

    protected void _init() {
        this.setLayout(new BorderLayout(12, 12));
        this.initModels();
        this.m_setsComboBox = new JComboBox(this.m_models);
        this.m_setsComboBox.addActionListener(new ComboBoxHandler());
        Box north = Box.createHorizontalBox();
        north.add(new JLabel(Messages.getMessage("Shortcuts.Options.Select.Label")));
        north.add(Box.createHorizontalStrut(6));
        north.add(this.m_setsComboBox);
        this.m_keyTable = new JTable(this.m_currentModel);
        this.m_keyTable.getTableHeader().setReorderingAllowed(false);
        this.m_keyTable.addMouseListener(new TableMouseHandler());
        Dimension d = this.m_keyTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.m_keyTable);
        scroller.setPreferredSize(d);
        this.add("North", north);
        this.add("Center", scroller);
    }

    protected void _save() {
        if (this.m_keyTable.getCellEditor() != null) {
            this.m_keyTable.getCellEditor().stopCellEditing();
        }
        Iterator e = this.m_models.iterator();
        while (e.hasNext()) {
            ((ActionSetTableModel)e.next()).save();
        }
    }

    public String toString() {
        return this.getTitle();
    }

    private void initModels() {
        this.m_models = new Vector();
        Iterator itr = ActionManager.getActionSets().iterator();
        while (itr.hasNext()) {
            ActionSet actionSet = (ActionSet)itr.next();
            if (actionSet.getActionCount() <= 0) continue;
            String modelLabel = actionSet.getLabel();
            ActionSetTableModel model = new ActionSetTableModel(actionSet);
            if (model.getRowCount() <= 0) continue;
            this.m_models.addElement(model);
        }
        MiscUtilities.quicksort(this.m_models, (Comparator)new MiscUtilities.StringICaseCompare());
        this.m_currentModel = (ActionSetTableModel)this.m_models.elementAt(0);
    }

    public Vector createAllBindings() {
        Vector<GrabKeyDialog.KeyBinding> set = new Vector<GrabKeyDialog.KeyBinding>();
        Iterator itr = this.m_models.iterator();
        while (itr.hasNext()) {
            ActionSetTableModel model = (ActionSetTableModel)itr.next();
            Iterator itr2 = model.m_set.iterator();
            while (itr2.hasNext()) {
                set.add((GrabKeyDialog.KeyBinding)itr2.next());
            }
        }
        return set;
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            int row = ShortcutsOptionPane.this.m_keyTable.getSelectedRow();
            int col = ShortcutsOptionPane.this.m_keyTable.getSelectedColumn();
            if (col != 0 && row != -1) {
                Vector allBindings = ShortcutsOptionPane.this.createAllBindings();
                GrabKeyDialog gkd = new GrabKeyDialog((Dialog)GUIUtilities.getParentDialog(ShortcutsOptionPane.this), ShortcutsOptionPane.this.m_currentModel.getBindingAt(row), allBindings);
                if (gkd.isOK()) {
                    ShortcutsOptionPane.this.m_currentModel.setValueAt(gkd.getShortcut(), row, col);
                }
            }
        }
    }

    private class ComboBoxHandler
    implements ActionListener {
        private ComboBoxHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            ActionSetTableModel newModel = (ActionSetTableModel)ShortcutsOptionPane.this.m_setsComboBox.getSelectedItem();
            if (ShortcutsOptionPane.this.m_currentModel != newModel) {
                ShortcutsOptionPane.this.m_currentModel = newModel;
                ShortcutsOptionPane.this.m_keyTable.setModel(ShortcutsOptionPane.this.m_currentModel);
            }
        }
    }

    private class ActionSetTableModel
    extends AbstractTableModel {
        public Vector m_set;
        private String m_name;

        public ActionSetTableModel(ActionSet set) {
            String[] names = set.getActionNames();
            this.m_set = new Vector(names.length);
            for (int i = 0; i < names.length; ++i) {
                String label = ActionManager.getLocalizedAction(names[i]).getLabel();
                if (label == null) {
                    Log.log(7, this, names[i] + " has a null label");
                    continue;
                }
                if (ActionManager.isDocViewSpecific(names[i])) continue;
                String binding = jsXe.getProperty(names[i] + ".shortcut");
                this.m_set.add(new GrabKeyDialog.KeyBinding(names[i], label, binding));
            }
            MiscUtilities.quicksort(this.m_set, (Comparator)new KeyCompare());
            this.m_name = set.getLabel();
        }

        public GrabKeyDialog.KeyBinding getBindingAt(int row) {
            return (GrabKeyDialog.KeyBinding)this.m_set.elementAt(row);
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Messages.getMessage("Shortcuts.Options.Command");
                }
                case 1: {
                    return Messages.getMessage("Shortcuts.Options.Shortcut");
                }
            }
            return null;
        }

        public int getRowCount() {
            return this.m_set.size();
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return ((GrabKeyDialog.KeyBinding)this.m_set.get((int)row)).label;
                }
                case 1: {
                    KeyEventTranslator.Key key = KeyEventTranslator.parseKey(((GrabKeyDialog.KeyBinding)this.m_set.get((int)row)).shortcut);
                    if (key != null) {
                        return key.toString();
                    }
                    return null;
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                return;
            }
            Log.log(1, this, "setting shortcut value: " + value);
            ((GrabKeyDialog.KeyBinding)this.m_set.get((int)row)).shortcut = (String)value;
            this.fireTableDataChanged();
        }

        public String toString() {
            return this.m_name;
        }

        public void save() {
            Iterator e = this.m_set.iterator();
            while (e.hasNext()) {
                GrabKeyDialog.KeyBinding binding = (GrabKeyDialog.KeyBinding)e.next();
                Log.log(1, this, "saving " + binding.name + " shortcut value: " + binding.shortcut);
                jsXe.setProperty(binding.name + ".shortcut", binding.shortcut);
            }
        }

        private class KeyCompare
        implements Comparator {
            private KeyCompare() {
            }

            public int compare(Object obj1, Object obj2) {
                String label1 = ((GrabKeyDialog.KeyBinding)obj1).label;
                String label2 = ((GrabKeyDialog.KeyBinding)obj2).label;
                return MiscUtilities.compareStrings(label1, label2, true);
            }
        }
    }
}

