/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.text.Segment;
import net.sourceforge.jsxe.OperatingSystem;

public class MiscUtilities {
    public static final String UTF_8_Y = "UTF-8Y";

    public static String canonPath(String path) {
        if (File.separatorChar == '\\') {
            path = path.replace('/', '\\');
        }
        if (path.startsWith("~" + File.separator)) {
            path = path.substring(2);
            String home = System.getProperty("user.home");
            if (home.endsWith(File.separator)) {
                return home + path;
            }
            return home + File.separator + path;
        }
        if (path.equals("~")) {
            return System.getProperty("user.home");
        }
        return path;
    }

    public static boolean isAbsolutePath(String path) {
        if (MiscUtilities.isURL(path)) {
            return true;
        }
        if (OperatingSystem.isDOSDerived()) {
            if (path.length() >= 2 && path.charAt(1) == ':') {
                return true;
            }
            if (path.startsWith("\\\\")) {
                return true;
            }
        } else if (OperatingSystem.isUnix() && path.length() > 0 && path.charAt(0) == '/') {
            return true;
        }
        return false;
    }

    public static String concatPath(String parent, String path) {
        parent = MiscUtilities.canonPath(parent);
        if ((path = MiscUtilities.canonPath(path)).startsWith(File.separator)) {
            path = path.substring(1);
        } else if (path.length() >= 3 && path.charAt(1) == ':') {
            path = path.replace(':', File.separatorChar);
        }
        if (parent == null) {
            parent = System.getProperty("user.dir");
        }
        if (parent.endsWith(File.separator)) {
            return parent + path;
        }
        return parent + File.separator + path;
    }

    public static String getFileExtension(String name) {
        int index = name.indexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(index);
    }

    public static String getFileName(String path) {
        if (path.equals("/")) {
            return path;
        }
        int count = Math.max(0, path.length() - 2);
        int index = Math.max(path.lastIndexOf(47, count), path.lastIndexOf(File.separatorChar, count));
        if (index == -1) {
            index = path.indexOf(58);
        }
        if (index == -1 || index == path.length() - 1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static String getParentOfPath(String path) {
        int count = Math.max(0, path.length() - 2);
        int index = path.lastIndexOf(File.separatorChar, count);
        if (index == -1) {
            index = path.lastIndexOf(47, count);
        }
        if (index == -1) {
            index = path.lastIndexOf(58);
        }
        return path.substring(0, index + 1);
    }

    public static String getProtocolOfURL(String url) {
        return url.substring(0, url.indexOf(58));
    }

    public static boolean isURL(String str) {
        int fsIndex = Math.max(str.indexOf(File.separatorChar), str.indexOf(47));
        if (fsIndex == 0) {
            return false;
        }
        if (fsIndex == 2) {
            return false;
        }
        int cIndex = str.indexOf(58);
        if (cIndex <= 1) {
            return false;
        }
        return fsIndex == -1 || cIndex <= fsIndex;
    }

    public static void saveBackup(File file, int backups, String backupPrefix, String backupSuffix, String backupDirectory) {
        if (backupPrefix == null) {
            backupPrefix = "";
        }
        if (backupSuffix == null) {
            backupSuffix = "";
        }
        String name = file.getName();
        if (backups == 1) {
            File backupFile = new File(backupDirectory, backupPrefix + name + backupSuffix);
            backupFile.delete();
            file.renameTo(backupFile);
        } else {
            new File(backupDirectory, backupPrefix + name + backupSuffix + backups + backupSuffix).delete();
            for (int i = backups - 1; i > 0; --i) {
                File backup = new File(backupDirectory, backupPrefix + name + backupSuffix + i + backupSuffix);
                backup.renameTo(new File(backupDirectory, backupPrefix + name + backupSuffix + (i + 1) + backupSuffix));
            }
            file.renameTo(new File(backupDirectory, backupPrefix + name + backupSuffix + "1" + backupSuffix));
        }
    }

    public static String fileToClass(String name) {
        char[] clsName = name.toCharArray();
        for (int i = clsName.length - 6; i >= 0; --i) {
            if (clsName[i] != '/') continue;
            clsName[i] = 46;
        }
        return new String(clsName, 0, clsName.length - 6);
    }

    public static String classToFile(String name) {
        return name.replace('.', '/').concat(".class");
    }

    public static String resolveSymlinks(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException io) {
            return path;
        }
    }

    public static int getLeadingWhiteSpace(String str) {
        int whitespace;
        block3: for (whitespace = 0; whitespace < str.length(); ++whitespace) {
            switch (str.charAt(whitespace)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return whitespace;
    }

    public static int getTrailingWhiteSpace(String str) {
        int whitespace = 0;
        block3: for (int i = str.length() - 1; i >= 0; --i) {
            switch (str.charAt(i)) {
                case '\t': 
                case ' ': {
                    ++whitespace;
                    continue block3;
                }
            }
        }
        return whitespace;
    }

    public static int getLeadingWhiteSpaceWidth(String str, int tabSize) {
        int whitespace = 0;
        block4: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case ' ': {
                    ++whitespace;
                    continue block4;
                }
                case '\t': {
                    whitespace += tabSize - whitespace % tabSize;
                    continue block4;
                }
            }
        }
        return whitespace;
    }

    public static int getVirtualWidth(Segment seg, int tabSize) {
        int virtualPosition = 0;
        for (int i = 0; i < seg.count; ++i) {
            char ch = seg.array[seg.offset + i];
            if (ch == '\t') {
                virtualPosition += tabSize - virtualPosition % tabSize;
                continue;
            }
            ++virtualPosition;
        }
        return virtualPosition;
    }

    public static int getOffsetOfVirtualColumn(Segment seg, int tabSize, int column, int[] totalVirtualWidth) {
        int virtualPosition = 0;
        for (int i = 0; i < seg.count; ++i) {
            char ch = seg.array[seg.offset + i];
            if (ch == '\t') {
                int tabWidth = tabSize - virtualPosition % tabSize;
                if (virtualPosition >= column) {
                    return i;
                }
                virtualPosition += tabWidth;
                continue;
            }
            if (virtualPosition >= column) {
                return i;
            }
            ++virtualPosition;
        }
        if (totalVirtualWidth != null) {
            totalVirtualWidth[0] = virtualPosition;
        }
        return -1;
    }

    public static String createWhiteSpace(int len, int tabSize) {
        StringBuffer buf = new StringBuffer();
        if (tabSize == 0) {
            while (len-- > 0) {
                buf.append(' ');
            }
        } else {
            int count = len / tabSize;
            while (count-- > 0) {
                buf.append('\t');
            }
            count = len % tabSize;
            while (count-- > 0) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public static String globToRE(String glob) {
        StringBuffer buf = new StringBuffer();
        boolean backslash = false;
        boolean insideGroup = false;
        boolean insideNegativeLookahead = false;
        block9: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            if (backslash) {
                buf.append('\\');
                buf.append(c);
                backslash = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    backslash = true;
                    continue block9;
                }
                case '?': {
                    buf.append('.');
                    continue block9;
                }
                case '.': {
                    buf.append("\\.");
                    continue block9;
                }
                case '*': {
                    buf.append(".*");
                    continue block9;
                }
                case '{': {
                    buf.append('(');
                    if (i + 1 != glob.length() && glob.charAt(i + 1) == '!') {
                        buf.append('?');
                        insideNegativeLookahead = true;
                        continue block9;
                    }
                    insideGroup = true;
                    continue block9;
                }
                case ',': {
                    if (insideGroup) {
                        if (insideNegativeLookahead) {
                            buf.append(").*");
                            insideNegativeLookahead = false;
                        }
                        buf.append('|');
                        continue block9;
                    }
                    buf.append(',');
                    continue block9;
                }
                case '}': {
                    if (insideNegativeLookahead) {
                        buf.append(").*");
                        insideNegativeLookahead = false;
                        continue block9;
                    }
                    if (insideGroup) {
                        buf.append(')');
                        insideGroup = false;
                        continue block9;
                    }
                    buf.append('}');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String escapesToChars(String str) {
        StringBuffer buf = new StringBuffer();
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    if (i == str.length() - 1) {
                        buf.append('\\');
                        continue block7;
                    }
                    c = str.charAt(++i);
                    switch (c) {
                        case 'n': {
                            buf.append('\n');
                            continue block7;
                        }
                        case 't': {
                            buf.append('\t');
                            continue block7;
                        }
                    }
                    buf.append(c);
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String charsToEscapes(String str) {
        return MiscUtilities.charsToEscapes(str, "\n\t\\\"'");
    }

    public static String charsToEscapes(String str, String toEscape) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (toEscape.indexOf(c) != -1) {
                if (c == '\n') {
                    buf.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    buf.append("\\t");
                    continue;
                }
                buf.append('\\');
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static int compareStrings(String str1, String str2, boolean ignoreCase) {
        char[] char1 = str1.toCharArray();
        char[] char2 = str2.toCharArray();
        int len = Math.min(char1.length, char2.length);
        int i = 0;
        for (int j = 0; i < len && j < len; ++i, ++j) {
            char ch1 = char1[i];
            char ch2 = char2[j];
            if (Character.isDigit(ch1) && Character.isDigit(ch2) && ch1 != '0' && ch2 != '0') {
                int _i;
                int _j = j + 1;
                for (_i = i + 1; _i < char1.length && Character.isDigit(char1[_i]); ++_i) {
                }
                while (_j < char2.length && Character.isDigit(char2[_j])) {
                    ++_j;
                }
                int len1 = _i - i;
                int len2 = _j - j;
                if (len1 > len2) {
                    return 1;
                }
                if (len1 < len2) {
                    return -1;
                }
                for (int k = 0; k < len1; ++k) {
                    ch1 = char1[i + k];
                    ch2 = char2[j + k];
                    if (ch1 == ch2) continue;
                    return ch1 - ch2;
                }
                i = _i - 1;
                j = _j - 1;
                continue;
            }
            if (ignoreCase) {
                ch1 = Character.toLowerCase(ch1);
                ch2 = Character.toLowerCase(ch2);
            }
            if (ch1 == ch2) continue;
            return ch1 - ch2;
        }
        return char1.length - char2.length;
    }

    public static boolean stringsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static void quicksort(Object[] obj, Comparator compare) {
        Arrays.sort(obj, compare);
    }

    public static void quicksort(Vector vector, Comparator compare) {
        Collections.sort(vector, compare);
    }

    public static void quicksort(List list, Comparator compare) {
        Collections.sort(list, compare);
    }

    public static String buildToVersion(String build) {
        if (build.length() != 11) {
            return "<unknown version: " + build + ">";
        }
        try {
            int major = Integer.parseInt(build.substring(0, 2));
            int minor = Integer.parseInt(build.substring(3, 5));
            int beta = Integer.parseInt(build.substring(6, 8));
            int bugfix = Integer.parseInt(build.substring(9, 11));
            return "" + major + "." + minor + (beta != 99 ? " pre" + beta : (bugfix != 0 ? "." + bugfix : "") + (major >= 1 ? " final" : " beta"));
        }
        catch (NumberFormatException e) {
            return "<unknown version: " + build + ">";
        }
    }

    public static int parsePermissions(String s) {
        int permissions = 0;
        if (s.length() == 9) {
            if (s.charAt(0) == 'r') {
                permissions += 256;
            }
            if (s.charAt(1) == 'w') {
                permissions += 128;
            }
            if (s.charAt(2) == 'x') {
                permissions += 64;
            } else if (s.charAt(2) == 's') {
                permissions += 2112;
            } else if (s.charAt(2) == 'S') {
                permissions += 2048;
            }
            if (s.charAt(3) == 'r') {
                permissions += 32;
            }
            if (s.charAt(4) == 'w') {
                permissions += 16;
            }
            if (s.charAt(5) == 'x') {
                permissions += 8;
            } else if (s.charAt(5) == 's') {
                permissions += 1032;
            } else if (s.charAt(5) == 'S') {
                permissions += 1024;
            }
            if (s.charAt(6) == 'r') {
                permissions += 4;
            }
            if (s.charAt(7) == 'w') {
                permissions += 2;
            }
            if (s.charAt(8) == 'x') {
                ++permissions;
            } else if (s.charAt(8) == 't') {
                permissions += 513;
            } else if (s.charAt(8) == 'T') {
                permissions += 512;
            }
        }
        return permissions;
    }

    public static String getLocalNameFromQualifiedName(String qualifiedName) {
        int index = qualifiedName.indexOf(":");
        String localName = index > 0 ? qualifiedName.substring(index + 1) : qualifiedName;
        return localName;
    }

    public static String getNSPrefixFromQualifiedName(String qualifiedName) {
        int index = qualifiedName.indexOf(":");
        String prefix = null;
        if (index != -1) {
            prefix = qualifiedName.substring(0, index);
        }
        return prefix;
    }

    public static String charactersToEntities(String s, Map hash) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            Character c;
            String entity;
            char ch = s.charAt(i);
            if ((ch >= '\u007f' || ch == '<' || ch == '>' || ch == '&' || ch == '\"' || ch == '\'') && (entity = (String)hash.get(c = new Character(ch))) != null) {
                buf.append('&');
                buf.append(entity);
                buf.append(';');
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String entitiesToCharacters(String s, Map hash) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            String entityName;
            Character c;
            int index;
            char ch = s.charAt(i);
            if (ch == '&' && (index = s.indexOf(59, i)) != -1 && (c = (Character)hash.get(entityName = s.substring(i + 1, index))) != null) {
                buf.append(c.charValue());
                i = index;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String uriToFile(String uri) {
        if (uri.startsWith("file:/")) {
            int start = uri.startsWith("file:///") && OperatingSystem.isDOSDerived() ? 8 : (uri.startsWith("file://") ? 7 : 5);
            StringBuffer buf = new StringBuffer();
            for (int i = start; i < uri.length(); ++i) {
                char ch = uri.charAt(i);
                if (ch == '/') {
                    buf.append(File.separatorChar);
                    continue;
                }
                if (ch == '%') {
                    String str = uri.substring(i + 1, i + 3);
                    buf.append((char)Integer.parseInt(str, 16));
                    i += 2;
                    continue;
                }
                buf.append(ch);
            }
            uri = buf.toString();
        }
        return uri;
    }

    public static boolean isSupportedEncoding(String encoding) {
        if (UTF_8_Y.equals(encoding)) {
            return true;
        }
        return Charset.isSupported(encoding);
    }

    public static String[] getSupportedEncodings() {
        ArrayList<String> returnValue = new ArrayList<String>();
        SortedMap<String, Charset> map = Charset.availableCharsets();
        Iterator iter = map.keySet().iterator();
        returnValue.add(UTF_8_Y);
        while (iter.hasNext()) {
            returnValue.add((String)iter.next());
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    public static Properties mergeProperties(Properties props1, Properties props2) {
        String name;
        if (props1 == null) {
            return props2;
        }
        if (props2 == null) {
            return props1;
        }
        Properties props = new Properties();
        Enumeration<?> names = props2.propertyNames();
        while (names.hasMoreElements()) {
            name = names.nextElement().toString();
            props.setProperty(name, props2.getProperty(name));
        }
        names = props1.propertyNames();
        while (names.hasMoreElements()) {
            name = names.nextElement().toString();
            props.setProperty(name, props1.getProperty(name));
        }
        return props;
    }

    public static boolean isTrue(String str) {
        return "true".equalsIgnoreCase(str);
    }

    public static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return b.equals(a);
    }

    private MiscUtilities() {
    }

    public static class MenuItemCompare
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            return MiscUtilities.compareStrings(((JMenuItem)obj1).getText(), ((JMenuItem)obj2).getText(), true);
        }
    }

    public static class StringICaseCompare
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            return MiscUtilities.compareStrings(obj1.toString(), obj2.toString(), true);
        }
    }

    public static class StringCompare
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            return MiscUtilities.compareStrings(obj1.toString(), obj2.toString(), false);
        }
    }
}

