/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.PlainDocument;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jsxe.ActionManager;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.EBListener;
import net.sourceforge.jsxe.EBMessage;
import net.sourceforge.jsxe.EditBus;
import net.sourceforge.jsxe.ViewPlugin;
import net.sourceforge.jsxe.dom.AdapterNode;
import net.sourceforge.jsxe.dom.XMLDocument;
import net.sourceforge.jsxe.dom.XMLDocumentListener;
import net.sourceforge.jsxe.gui.DocumentView;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.msg.PropertyChanged;
import org.xml.sax.SAXException;
import treeview.DefaultViewDocument;
import treeview.DefaultViewTableModel;
import treeview.DefaultViewTreeModel;
import treeview.EditTagDialog;
import treeview.TreeViewPlugin;
import treeview.TreeViewTree;

public class DefaultView
extends JPanel
implements DocumentView,
EBListener {
    private static final Properties m_defaultProperties;
    public static final String CONTINUOUS_LAYOUT = "treeview.continuous.layout";
    public static final String VERT_SPLIT_LOCATION = "treeview.splitpane.vert.loc";
    public static final String HORIZ_SPLIT_LOCATION = "treeview.splitpane.horiz.loc";
    public static final String SHOW_COMMENTS = "treeview.show.comment.nodes";
    public static final String SHOW_EMPTY_NODES = "treeview.show.empty.nodes";
    public static final String SHOW_ATTRIBUTES = "treeview.show.attributes";
    private TreeViewTree tree = new TreeViewTree();
    private JTextArea m_valueTextArea = new JTextArea("");
    private DefaultViewTable attributesTable = new DefaultViewTable();
    private JSplitPane vertSplitPane;
    private JSplitPane horizSplitPane;
    private DocumentBuffer m_document;
    private boolean m_viewShown = false;
    private TreeViewPlugin m_plugin;
    private JMenu m_editMenu;
    private EditTagDialog.ComboValueRenderer m_comboRenderer = new EditTagDialog.ComboValueRenderer();
    private TableModelListener tableListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            DefaultView.this.attributesTable.updateUI();
        }
    };
    private TreeModelListener treeListener = new TreeModelListener(){

        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
            DefaultView.this.tree.updateUI();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            DefaultView.this.tree.updateUI();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            DefaultView.this.tree.updateUI();
        }
    };
    private DocumentListener docListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
        }

        public void removeUpdate(DocumentEvent e) {
        }
    };
    private XMLDocumentListener m_documentListener = new XMLDocumentListener(){

        public void propertyChanged(XMLDocument source, String key, String oldValue) {
        }

        public void structureChanged(XMLDocument source, AdapterNode location) {
            DefaultView.this.tree.updateUI();
            ((DefaultViewTableModel)DefaultView.this.attributesTable.getModel()).updateTable();
            DefaultView.this.attributesTable.updateUI();
        }
    };
    static /* synthetic */ Class class$treeview$DefaultView;

    public DefaultView(DocumentBuffer document, TreeViewPlugin plugin) throws IOException {
        this.m_plugin = plugin;
        this.enableEvents(8L);
        this.setLayout(new BorderLayout());
        this.m_valueTextArea.setName("TreeViewTextArea");
        this.m_valueTextArea.setEditable(false);
        this.m_valueTextArea.setFont(new Font("Monospaced", 0, 12));
        this.m_valueTextArea.setLineWrap(false);
        JScrollPane htmlView = new JScrollPane(this.m_valueTextArea);
        JScrollPane attrView = new JScrollPane(this.attributesTable);
        this.attributesTable.setName("TreeViewAttributesTable");
        this.attributesTable.setColumnSelectionAllowed(false);
        this.attributesTable.setRowSelectionAllowed(false);
        this.attributesTable.addMouseListener(new TablePopupListener());
        this.attributesTable.setRowHeight(new JComboBox<String>(new String[]{"template"}).getPreferredSize().height);
        this.tree.setName("TreeViewTree");
        JScrollPane treeView = new JScrollPane(this.tree);
        this.tree.addTreeSelectionListener(new DefaultTreeSelectionListener(this));
        this.m_editMenu = new JMenu(Messages.getMessage((String)"Edit.Menu"));
        this.m_editMenu.setMnemonic('E');
        JMenuItem menuItem = new JMenuItem(ActionManager.getAction((String)"cut"));
        this.m_editMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction((String)"copy"));
        this.m_editMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction((String)"paste"));
        this.m_editMenu.add(menuItem);
        this.vertSplitPane = new JSplitPane(0, treeView, attrView);
        this.vertSplitPane.setContinuousLayout(false);
        this.vertSplitPane.setOneTouchExpandable(true);
        this.horizSplitPane = new JSplitPane(1, this.vertSplitPane, htmlView);
        this.horizSplitPane.setContinuousLayout(false);
        this.horizSplitPane.setOneTouchExpandable(true);
        this.add((Component)this.horizSplitPane, "Center");
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
                DefaultView.this.tree.requestFocus();
                Container parent = DefaultView.this.getParent();
                if (parent != null) {
                    Dimension size = parent.getSize();
                    float vertPercent = Integer.valueOf(jsXe.getProperty((String)DefaultView.VERT_SPLIT_LOCATION)).floatValue();
                    float horizPercent = Integer.valueOf(jsXe.getProperty((String)DefaultView.HORIZ_SPLIT_LOCATION)).floatValue();
                    int vertLoc = (int)((double)vertPercent / 100.0 * size.getHeight());
                    int horizLoc = (int)((double)horizPercent / 100.0 * size.getWidth());
                    DefaultView.this.vertSplitPane.setDividerLocation(vertLoc);
                    DefaultView.this.horizSplitPane.setDividerLocation(horizLoc);
                    DefaultView.this.m_viewShown = true;
                    DefaultView.this.removeComponentListener(this);
                }
            }
        });
        this.setDocumentBuffer(document);
        EditBus.addToBus((EBListener)this);
    }

    public boolean close() {
        if (this.m_document != null && this.m_viewShown) {
            Dimension size = this.getSize();
            String vert = Integer.toString((int)((double)this.vertSplitPane.getDividerLocation() / size.getHeight() * 100.0));
            String horiz = Integer.toString((int)((double)this.horizSplitPane.getDividerLocation() / size.getWidth() * 100.0));
            jsXe.setProperty((String)VERT_SPLIT_LOCATION, (String)vert);
            jsXe.setProperty((String)HORIZ_SPLIT_LOCATION, (String)horiz);
            this.m_document.removeXMLDocumentListener(this.m_documentListener);
        }
        EditBus.removeFromBus((EBListener)this);
        return true;
    }

    public Component getDocumentViewComponent() {
        return this;
    }

    public ViewPlugin getViewPlugin() {
        return this.m_plugin;
    }

    public JMenu[] getMenus() {
        return new JMenu[]{this.m_editMenu};
    }

    public DocumentBuffer getDocumentBuffer() {
        return this.m_document;
    }

    public void setDocumentBuffer(DocumentBuffer document) throws IOException {
        try {
            document.checkWellFormedness();
        }
        catch (SAXException e) {
            String errormsg = "The tree view requires XML documents to be well-formed.\n\n" + e.toString();
            throw new IOException(errormsg);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        AdapterNode adapter = document.getAdapterNode();
        DefaultViewTreeModel treeModel = new DefaultViewTreeModel(this, (XMLDocument)document);
        DefaultViewTableModel tableModel = new DefaultViewTableModel(this, adapter);
        DefaultViewDocument styledDoc = new DefaultViewDocument(adapter);
        this.tree.setModel(treeModel);
        this.attributesTable.setModel(tableModel);
        treeModel.addTreeModelListener(this.treeListener);
        tableModel.addTableModelListener(this.tableListener);
        this.m_valueTextArea.setDocument(styledDoc);
        styledDoc.addDocumentListener(this.docListener);
        boolean layout = Boolean.valueOf(jsXe.getProperty((String)CONTINUOUS_LAYOUT));
        this.vertSplitPane.setContinuousLayout(layout);
        this.horizSplitPane.setContinuousLayout(layout);
        this.attributesTable.updateUI();
        this.tree.updateUI();
        this.updateUI();
        this.m_document = document;
        this.m_document.addXMLDocumentListener(this.m_documentListener);
    }

    public boolean goToLine(int lineNo) {
        return false;
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof PropertyChanged) {
            String key = ((PropertyChanged)message).getKey();
            if (CONTINUOUS_LAYOUT.equals(key)) {
                boolean layout = Boolean.valueOf(jsXe.getProperty((String)CONTINUOUS_LAYOUT));
                this.vertSplitPane.setContinuousLayout(layout);
                this.horizSplitPane.setContinuousLayout(layout);
            }
            if (CONTINUOUS_LAYOUT.equals(key) || SHOW_COMMENTS.equals(key) || SHOW_ATTRIBUTES.equals(key)) {
                this.tree.updateUI();
            }
        }
    }

    public TreeViewTree getTree() {
        return this.tree;
    }

    public JTextArea getDefaultViewTextPane() {
        return this.m_valueTextArea;
    }

    public JTable getDefaultViewAttributeTable() {
        return this.attributesTable;
    }

    private boolean canEditInJEditorPane(AdapterNode node) {
        return node.getNodeValue() != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        InputStream viewinputstream = (class$treeview$DefaultView == null ? (class$treeview$DefaultView = DefaultView.class$("treeview.DefaultView")) : class$treeview$DefaultView).getResourceAsStream("/treeview/treeview.props");
        m_defaultProperties = new Properties();
        try {
            m_defaultProperties.load(viewinputstream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class DefaultViewTable
    extends JTable {
        public void editingStopped(ChangeEvent e) {
            int editRow = this.getEditingRow();
            int editColumn = this.getEditingColumn();
            super.editingStopped(e);
            if (editRow == this.getRowCount() - 1) {
                editColumn = editColumn == 0 ? 1 : 0;
                this.editCellAt(editRow, editColumn);
            }
        }

        public TableCellEditor getCellEditor(int row, int column) {
            Object value = this.getModel().getValueAt(row, column);
            if (value instanceof EditTagDialog.Attribute.Value) {
                return DefaultView.this.m_comboRenderer;
            }
            return super.getCellEditor(row, column);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            Object value = this.getModel().getValueAt(row, column);
            if (value instanceof EditTagDialog.Attribute.Value) {
                return DefaultView.this.m_comboRenderer;
            }
            return super.getCellRenderer(row, column);
        }
    }

    private class DefaultTreeSelectionListener
    implements TreeSelectionListener {
        private Component parent;

        DefaultTreeSelectionListener(Component p) {
            this.parent = p;
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath selPath = e.getPath();
            AdapterNode selectedNode = (AdapterNode)selPath.getLastPathComponent();
            if (selectedNode != null) {
                DefaultView.this.m_valueTextArea.setEditable(DefaultView.this.canEditInJEditorPane(selectedNode));
                if (DefaultView.this.attributesTable.isEditing()) {
                    int row = DefaultView.this.attributesTable.getEditingRow();
                    int column = DefaultView.this.attributesTable.getEditingColumn();
                    DefaultView.this.attributesTable.getCellEditor(row, column).cancelCellEditing();
                }
                ((DefaultViewTableModel)DefaultView.this.attributesTable.getModel()).setAdapterNode(selectedNode);
                DefaultViewDocument styledDoc = new DefaultViewDocument(selectedNode);
                DefaultView.this.m_valueTextArea.setDocument(styledDoc);
                styledDoc.addDocumentListener(DefaultView.this.docListener);
                DefaultView.this.m_valueTextArea.updateUI();
            } else {
                DefaultView.this.m_valueTextArea.setDocument(new PlainDocument());
                DefaultView.this.m_valueTextArea.setEditable(false);
            }
        }
    }

    private class TablePopupListener
    extends MouseAdapter {
        private TablePopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            Point point = new Point(e.getX(), e.getY());
            int row = DefaultView.this.attributesTable.rowAtPoint(point);
            int column = DefaultView.this.attributesTable.columnAtPoint(point);
            DefaultView.this.attributesTable.setColumnSelectionInterval(column, column);
            DefaultView.this.attributesTable.setRowSelectionInterval(row, row);
            if (e.isPopupTrigger() && row != -1) {
                DefaultViewTableModel model = (DefaultViewTableModel)DefaultView.this.attributesTable.getModel();
                JPopupMenu popup = new JPopupMenu();
                popup.add(ActionManager.getAction((String)"treeview.add.attribute"));
                if (row != DefaultView.this.attributesTable.getRowCount() - 1) {
                    popup.add(ActionManager.getAction((String)"treeview.remove.attribute"));
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

