/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.Toolkit;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.GapContent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleContext;
import net.sourceforge.jsxe.dom.AdapterNode;
import org.w3c.dom.DOMException;

public class DefaultViewDocument
extends DefaultStyledDocument {
    private AdapterNode node;

    protected DefaultViewDocument(AdapterNode n) {
        super((AbstractDocument.Content)new GapContent(), new StyleContext());
        try {
            String value;
            if (n != null && (value = n.getNodeValue()) != null) {
                super.insertString(0, value, new SimpleAttributeSet());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.node = n;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        try {
            String newNodeValue = super.getText(0, offs) + str + super.getText(offs, super.getLength() - offs);
            this.node.setNodeValue(newNodeValue);
            super.insertString(offs, str, a);
        }
        catch (DOMException dome) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        try {
            String newNodeValue = super.getText(0, offs) + super.getText(offs + len, super.getLength() - offs - len);
            this.node.setNodeValue(newNodeValue);
            super.remove(offs, len);
        }
        catch (DOMException dome) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

