/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.jsxe.dom.AdapterNode;
import net.sourceforge.jsxe.dom.XMLDocument;
import net.sourceforge.jsxe.dom.completion.ElementDecl;
import net.sourceforge.jsxe.dom.completion.IDDecl;
import net.sourceforge.jsxe.gui.EnhancedDialog;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.util.MiscUtilities;
import org.w3c.dom.NamedNodeMap;

public class EditTagDialog
extends EnhancedDialog {
    private ElementDecl element;
    private Map entityHash;
    private List attributeModel;
    private JTable attributes;
    private JTextArea preview;
    private JButton ok;
    private JButton cancel;
    private String newTag;
    private boolean isOK;
    private AdapterNode m_newNode;
    private XMLDocument m_document;
    private static ComboValueRenderer comboRenderer = new ComboValueRenderer();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public EditTagDialog(Frame view, ElementDecl element, Map attributeValues, boolean elementEmpty, Map entityHash, List ids, XMLDocument document, AdapterNode node) {
        this(view, element, attributeValues, elementEmpty, entityHash, ids, document);
        this.m_newNode = node;
        NamedNodeMap attributes = this.m_newNode.getAttributes();
        for (int i = 0; i < this.attributeModel.size(); ++i) {
            Attribute attr = (Attribute)this.attributeModel.get(i);
            if (attributes.getNamedItem(attr.name) == null) continue;
            attr.value.value = this.m_newNode.getAttribute(attr.name);
            attr.set = true;
        }
        this.updateTag();
    }

    public EditTagDialog(Frame view, ElementDecl element, Map attributeValues, boolean elementEmpty, Map entityHash, List ids, XMLDocument document) {
        super(view, Messages.getMessage((String)"Edit.Node.Dialog.Title"), true);
        this.m_document = document;
        this.element = element;
        this.entityHash = entityHash;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel top = new JPanel(new BorderLayout(6, 0));
        top.setBorder(new EmptyBorder(0, 0, 12, 0));
        top.add("West", new JLabel("Element name:"));
        top.add("Center", new JLabel(element.name));
        content.add("North", top);
        JPanel center = new JPanel(new BorderLayout());
        this.attributeModel = this.createAttributeModel(element.getAttributes(), attributeValues, ids);
        this.attributes = new AttributeTable();
        this.attributes.setModel(new AttributeTableModel());
        this.attributes.setRowHeight(new JComboBox<String>(new String[]{"template"}).getPreferredSize().height);
        this.attributes.getTableHeader().setReorderingAllowed(false);
        this.attributes.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.attributes.setColumnSelectionAllowed(false);
        this.attributes.setRowSelectionAllowed(false);
        this.attributes.setCellSelectionEnabled(false);
        JScrollPane scroller = new JScrollPane(this.attributes);
        Dimension size = scroller.getPreferredSize();
        size.height = Math.min(size.width, 200);
        scroller.setPreferredSize(size);
        center.add("Center", scroller);
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        previewPanel.add("North", new JLabel("Preview:"));
        this.preview = new JTextArea(5, 5);
        this.preview.setLineWrap(true);
        this.preview.setWrapStyleWord(true);
        this.preview.setEditable(false);
        previewPanel.add("Center", new JScrollPane(this.preview));
        center.add("South", previewPanel);
        content.add("Center", center);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttons.add(Box.createGlue());
        this.ok = new JButton(Messages.getMessage((String)"common.ok"));
        buttons.add(this.ok);
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(Messages.getMessage((String)"common.cancel"));
        buttons.add(this.cancel);
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.updateTag();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(view);
    }

    public void ok() {
        int i;
        int row = this.attributes.getSelectedRow();
        int column = this.attributes.getSelectedColumn();
        if (row != -1 && column != -1 && this.attributes.getCellEditor(row, column) != null) {
            this.attributes.getCellEditor(row, column).stopCellEditing();
        }
        if (this.m_newNode == null) {
            this.m_newNode = this.m_document.newAdapterNode(null, this.element.name, "", (short)1);
        }
        NamedNodeMap map = this.m_newNode.getAttributes();
        int len = map.getLength();
        for (i = 0; i < len; ++i) {
            this.m_newNode.removeAttribute(map.item(0).getNodeName());
        }
        for (i = 0; i < this.attributeModel.size(); ++i) {
            Attribute attr = (Attribute)this.attributeModel.get(i);
            if (!attr.set) continue;
            this.m_newNode.setAttribute(attr.name, attr.value.value);
        }
        this.isOK = true;
        this.dispose();
    }

    public void cancel() {
        this.isOK = false;
        this.dispose();
    }

    public String getNewTag() {
        return this.isOK ? this.newTag : null;
    }

    public AdapterNode getNewNode() {
        return this.isOK ? this.m_newNode : null;
    }

    private ArrayList createAttributeModel(List declaredAttributes, Map attributeValues, List ids) {
        ArrayList<String> stringIDs = new ArrayList<String>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            stringIDs.add(((IDDecl)ids.get((int)i)).id);
        }
        ArrayList<Attribute> attributeModel = new ArrayList<Attribute>();
        for (int i = 0; i < declaredAttributes.size(); ++i) {
            ArrayList<String> values;
            boolean set;
            ElementDecl.AttributeDecl attr = (ElementDecl.AttributeDecl)declaredAttributes.get(i);
            String value = (String)attributeValues.get(attr.name);
            if (value == null) {
                set = false;
                value = attr.value;
            } else {
                set = true;
            }
            if (attr.required) {
                set = true;
            }
            if (attr.type.equals("IDREF") && stringIDs.size() > 0) {
                values = stringIDs;
                if (value == null) {
                    value = (String)stringIDs.get(0);
                }
            } else {
                values = attr.values;
                if (value == null && values != null && values.size() > 0) {
                    value = (String)values.get(0);
                }
            }
            attributeModel.add(new Attribute(set, attr.name, value, values, attr.type, attr.required));
        }
        Collections.sort(attributeModel, new AttributeCompare());
        return attributeModel;
    }

    private void updateTag() {
        StringBuffer buf = new StringBuffer("<");
        buf.append(this.element.name);
        for (int i = 0; i < this.attributeModel.size(); ++i) {
            Attribute attr = (Attribute)this.attributeModel.get(i);
            if (!attr.set) continue;
            buf.append(' ');
            String attrName = attr.name;
            buf.append(attr.name);
            buf.append("=\"");
            if (attr.value.value != null) {
                buf.append(MiscUtilities.charactersToEntities((String)attr.value.value, (Map)this.entityHash));
            }
            buf.append("\"");
        }
        buf.append(">");
        this.newTag = buf.toString();
        this.preview.setText(this.newTag);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ComboValueRenderer
    extends DefaultCellEditor
    implements TableCellRenderer {
        JComboBox editorCombo;
        JComboBox renderCombo;

        ComboValueRenderer() {
            this(new JComboBox());
        }

        ComboValueRenderer(JComboBox comboBox) {
            super(comboBox);
            this.editorCombo = comboBox;
            this.editorCombo.setEditable(true);
            this.renderCombo = new JComboBox();
            this.renderCombo.setEditable(true);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Attribute.Value _value = (Attribute.Value)value;
            this.editorCombo.setModel(new DefaultComboBoxModel<Object>(_value.values.toArray()));
            return super.getTableCellEditorComponent(table, _value.value, isSelected, row, column);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Attribute.Value _value = (Attribute.Value)value;
            this.renderCombo.setModel(new DefaultComboBoxModel<Object>(_value.values.toArray()));
            this.renderCombo.setSelectedItem(_value.value);
            return this.renderCombo;
        }
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private AttributeTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return EditTagDialog.this.attributeModel.size();
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = EditTagDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return class$java$lang$String == null ? (class$java$lang$String = EditTagDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Set";
                }
                case 1: {
                    return "Attribute";
                }
                case 2: {
                    return "Type";
                }
                case 3: {
                    return "Value";
                }
            }
            throw new InternalError();
        }

        public boolean isCellEditable(int row, int col) {
            return col != 1 && col != 2;
        }

        public Object getValueAt(int row, int col) {
            Attribute attr = (Attribute)EditTagDialog.this.attributeModel.get(row);
            switch (col) {
                case 0: {
                    return new Boolean(attr.set);
                }
                case 1: {
                    return attr.name;
                }
                case 2: {
                    if (attr.required) {
                        if (attr.type.startsWith("(")) {
                            return "#REQUIRED";
                        }
                        return attr.type + ", " + "#REQUIRED";
                    }
                    if (attr.type.startsWith("(")) {
                        return "";
                    }
                    return attr.type;
                }
                case 3: {
                    if (attr.value.values != null) {
                        return attr.value;
                    }
                    return attr.value.value;
                }
            }
            throw new InternalError();
        }

        public void setValueAt(Object value, int row, int col) {
            Attribute attr = (Attribute)EditTagDialog.this.attributeModel.get(row);
            switch (col) {
                case 0: {
                    if (attr.required) {
                        return;
                    }
                    attr.set = (Boolean)value;
                    break;
                }
                case 3: {
                    String sValue = value instanceof IDDecl ? ((IDDecl)value).id : value.toString();
                    if (this.equal(attr.value.value, sValue)) {
                        return;
                    }
                    attr.set = true;
                    attr.value.value = sValue;
                }
            }
            this.fireTableRowsUpdated(row, row);
            EditTagDialog.this.updateTag();
        }

        private boolean equal(String str1, String str2) {
            if (str1 == null || str1.length() == 0) {
                return str2 == null || str2.length() == 0;
            }
            if (str2 == null) {
                return false;
            }
            return str1.equals(str2);
        }
    }

    private class AttributeTable
    extends JTable {
        private AttributeTable() {
        }

        public TableCellEditor getCellEditor(int row, int column) {
            Object value = this.getModel().getValueAt(row, column);
            if (value instanceof Attribute.Value) {
                return comboRenderer;
            }
            return super.getCellEditor(row, column);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            Object value = this.getModel().getValueAt(row, column);
            if (value instanceof Attribute.Value) {
                return comboRenderer;
            }
            return super.getCellRenderer(row, column);
        }
    }

    static class AttributeCompare
    implements Comparator {
        AttributeCompare() {
        }

        public int compare(Object obj1, Object obj2) {
            Attribute attr1 = (Attribute)obj1;
            Attribute attr2 = (Attribute)obj2;
            if (attr1.required && !attr2.required) {
                return -1;
            }
            if (!attr1.required && attr2.required) {
                return 1;
            }
            return MiscUtilities.compareStrings((String)attr1.name, (String)attr2.name, (boolean)true);
        }
    }

    static class Attribute {
        boolean set;
        String name;
        Value value;
        String type;
        boolean required;

        Attribute(boolean set, String name, String value, ArrayList values, String type, boolean required) {
            this.set = set;
            this.name = name;
            this.value = new Value(value, values);
            this.type = type;
            this.required = required;
        }

        static class Value {
            String value;
            ArrayList values;

            Value(String value, ArrayList values) {
                this.value = value;
                this.values = values;
            }

            public String toString() {
                return this.value;
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == EditTagDialog.this.ok) {
                EditTagDialog.this.ok();
            } else if (evt.getSource() == EditTagDialog.this.cancel) {
                EditTagDialog.this.cancel();
            }
        }
    }
}

