/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jsxe.dom.AdapterNode;

public class TransferableNode
implements Transferable {
    public static final DataFlavor stringFlavor = DataFlavor.stringFlavor;
    public static final DataFlavor nodeFlavor;
    private static final DataFlavor[] flavors;
    private static final List flavorList;
    private AdapterNode m_node;

    public TransferableNode(AdapterNode node) {
        this.m_node = node;
    }

    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavorList.contains(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (stringFlavor.equals(flavor)) {
            return this.m_node.serializeToString();
        }
        if (nodeFlavor.equals(flavor)) {
            return this.m_node;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    static {
        DataFlavor flav = null;
        try {
            flav = new DataFlavor(Class.forName("net.sourceforge.jsxe.dom.AdapterNode"), "XML Node");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        nodeFlavor = flav;
        flavors = new DataFlavor[]{stringFlavor, nodeFlavor};
        flavorList = Arrays.asList(flavors);
    }
}

