/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.test;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.TestTable;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="testTableDao" 
 * @spring.property name="dataSource" ref="dataSource" 
 * @spring.property name="sqlMapClient" ref="sqlMapClient" 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class TestTableDaoImpl extends BaseDao implements TestTableDao {
	
	/**
	 * 検索します。
	 * @param testTable エンティティ
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
    public List find(TestTable testTable) throws SampleException {
    	testTable.setId(toCondition(testTable.getId()));
    	testTable.setHoge1(toCondition(testTable.getHoge1()));
    	testTable.setHoge2(toCondition(testTable.getHoge2()));
    	testTable.setHoge3(toCondition(testTable.getHoge3()));
        return getSqlMapClientTemplate().queryForList("TEST_TABLE.find", testTable);
    }
    
	/**
	 * 登録します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(TestTable testTable) throws SampleException {
    	testTable.setId(null);
    	testTable.setCreateDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
    	testTable.setUpdateDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
    	getSqlMapClientTemplate().insert("TEST_TABLE.save", testTable);
    }

	/**
	 * 更新します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(TestTable testTable) throws SampleException {
    	testTable.setUpdateDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
    	getSqlMapClientTemplate().update("TEST_TABLE.update", testTable);
    }
    
	/**
	 * 削除します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(TestTable testTable) throws SampleException {
    	getSqlMapClientTemplate().delete("TEST_TABLE.delete", testTable);
    }
}
