/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.csv;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

import org.jtp.common.csv.CSVWriterFactory;


/**
 * CSVファイルを生成する為の基本クラスです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public abstract class CsvFactory implements Factory {
    
	/** 区切り文字 */
    protected static final String DELIMITER = "\t";
    
    /** CSV出力するリストのオブジェクト */
    private List list;
    
	/**
	 * コンストラクタ
	 * @param list CSV出力するリストのオブジェクト
	 */
    public CsvFactory(List list) {
    	this.list = list;
    }
    
    /**
     * 生成したCSVの入力ストリームを取得する
     * @param filename CSVファイル名
     * @return 生成したCSVの入力ストリーム
     * @throws IOException I/O例外
     */
    public InputStream getStream(String filename) throws IOException {
    	createCsvFile(filename);
    	InputStream result = null;
    	try {
    		result = new FileInputStream(filename);
    	}
    	catch (FileNotFoundException e) {
    		throw e;
    	}
    	return result;
    }

    /**
     * CSVファイルを作成する
     * @param filename CSVファイル名
     * @throws IOException I/O例外
     */
    protected void createCsvFile(String filename) throws IOException {
        CSVWriterFactory factory = new CSVWriterFactory(filename);

        PrintWriter writer = null;
        try {
            writer = factory.getWriter();
            for (int i = 0; i < list.size(); i++) {
            	//CSV出力
                writer.println(createRowString(list.get(i)));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        finally {
            if (writer != null)
                writer.close();
        }
    }
    
    /**
     * 出力行を作成する
     * @param object 出力情報オブジェクト
     * @return 出力行
     */
    protected abstract String createRowString(Object object);
}
