/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.csv;

import java.io.IOException;
import java.io.InputStream;

/**
 * ファイルを生成する為のインターフェースです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public interface Factory {

    /**
     * 生成したファイルの入力ストリームを取得する
     * @param filename ファイル名
     * @return 生成したの入力ストリーム
     * @throws IOException I/O例外
     */
    public InputStream getStream(String filename) throws IOException;
}
