<%--------------------------------------------------------------------------------------------
-- Java Template Project
-- 
-- Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
----------------------------------------------------------------------------------------------
-- ꗗ
-- 
-- author Satoshi Nagashiba
--------------------------------------------------------------------------------------------%>
<%@ page contentType="text/html;charset=Shift_JIS" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<h:panelGrid
  columns="1"
  styleClass="center"
  rendered="#{!empty sampleBean.searchList}">
  
  <%/* f[^e[ǔ\y[W荞 */%>
  <h:panelGroup>
    <jsp:include page="/jsp/common/statics.jsp" flush="false" />
  </h:panelGroup>

  <h:dataTable
    id="scrollable"
    var="entry"
    value="#{sampleBean.searchList}"
    rows="#{pager.rows}"
    styleClass="list"
    rowClasses="oddRow,evenRow"
    columnClasses="right,left,left,left,datetime,datetime,button,button"
    width="1000">

    <%/* ID */%>
    <h:column>
      <f:facet name="header">
        <h:outputText value="ID" />
      </f:facet>
       <h:outputText value="#{entry.testTable.id}" />
    </h:column>
    
    <%/* قP */%>
    <h:column>
      <f:facet name="header">
        <h:outputText value="قP" />
      </f:facet>
       <h:outputText value="#{entry.testTable.hoge1}" />
    </h:column>
    
    <%/* قQ */%>
    <h:column>
      <f:facet name="header">
        <h:outputText value="قQ" />
      </f:facet>
       <h:outputText value="#{entry.testTable.hoge2}" />
    </h:column>

   <%/* قR */%>
    <h:column>
      <f:facet name="header">
        <h:outputText value="قR" />
      </f:facet>
       <h:outputText value="#{entry.testTable.hoge3}" />
    </h:column>
    
    <%/* 쐬 */%>
    <h:column>
      <f:facet name="header">
        <h:outputText value="쐬" />
      </f:facet>
      <h:outputText value="#{entry.testTable.createDate}">
        <f:convertDateTime pattern="#{globals.pattern_timestamp}" timeZone="Asia/Tokyo" />
      </h:outputText>
    </h:column>

    <%/* XV */%>
    <h:column>
      <f:facet name="header">
        <h:outputText value="XV" />
      </f:facet>
      <h:outputText value="#{entry.testTable.updateDate}">
        <f:convertDateTime pattern="#{globals.pattern_timestamp}" timeZone="Asia/Tokyo" />
      </h:outputText>
    </h:column>
    
    <%/* {^ */%>
    <h:column>
      <f:facet name="header" />
      <h:commandButton
        value="#{globals.button_modify}"
        immediate="true"
        action="update"
        actionListener="#{entry.update}" />
    </h:column>
    
    <%/* {^ */%>
    <h:column>
      <f:facet name="header" />
      <h:commandButton
        value="#{globals.button_delete}"
        immediate="true"
        action="remove"
        actionListener="#{entry.remove}" />
    </h:column>

  </h:dataTable>
  
  <%/* f[^e[ũXN[[y[W荞 */%>
  <h:panelGroup>
    <jsp:include page="/jsp/common/scroller.jsp" flush="false" />
  </h:panelGroup>

</h:panelGrid>
