<%--------------------------------------------------------------------------------------------
-- Java Template Project
-- 
-- Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
----------------------------------------------------------------------------------------------
-- XV
-- 
-- author Satoshi Nagashiba
--------------------------------------------------------------------------------------------%>
<%@ page contentType="text/html;charset=Shift_JIS" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<h:panelGrid
  columns="2"
  styleClass="update"
  columnClasses="label,none">

  <h:outputText value="ID" />
  <h:outputText value="#{sampleBean.testTable.id}" />

  <h:outputText value="قP" />
  <h:panelGroup>
    <h:inputText id="hoge1" value="#{sampleBean.testTable.hoge1}" size="50" required="true">
      <f:validator validatorId="hiragana"/>
    </h:inputText>
    <h:message for="hoge1" styleClass="message" />
  </h:panelGroup>
  
  <h:outputText value="قQ" />
  <h:panelGroup>
    <h:inputText id="hoge2" value="#{sampleBean.testTable.hoge2}" size="50" required="true">
      <f:validator validatorId="katakana"/>
    </h:inputText>
    <h:message for="hoge2" styleClass="message" />
  </h:panelGroup>

  <h:outputText value="قR" />
  <h:panelGroup>
    <h:inputText id="hoge3" value="#{sampleBean.testTable.hoge3}" size="50" required="true">
      <f:validator validatorId="hiragana"/>
    </h:inputText>
    <h:message for="hoge3" styleClass="message" />
  </h:panelGroup>

  <h:outputText value="쐬" />
  <h:outputText value="#{sampleBean.testTable.createDate}">
    <f:convertDateTime pattern="#{globals.pattern_timestamp}" timeZone="Asia/Tokyo" />
  </h:outputText>

  <h:outputText value="XV" />
  <h:outputText value="#{sampleBean.testTable.updateDate}">
    <f:convertDateTime pattern="#{globals.pattern_timestamp}" timeZone="Asia/Tokyo" />
  </h:outputText>

</h:panelGrid>

<f:verbatim><hr/></f:verbatim>

<%/* {^ */%>
<h:panelGrid columns="2">
  <h:commandButton
    value="#{globals.button_back}"
    immediate="true"
    action="back"
    style="width:100px" />
  <h:commandButton
    value="#{globals.button_update}"
    onclick="return window.confirm('XV܂H');"
    action="update"
    actionListener="#{sampleAction.update}"
    style="width:100px" />

</h:panelGrid>
