/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * テストテーブルのエンティティクラスです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class TestTable implements Serializable {

    /** identifier field */
    private Integer id;

    /** nullable persistent field */
    private String hoge1;

    /** nullable persistent field */
    private String hoge2;

    /** nullable persistent field */
    private String hoge3;

    /** nullable persistent field */
    private Date createDate;

    /** nullable persistent field */
    private Date updateDate;

    /** default constructor */
    public TestTable() {
    }

    /** minimal constructor */
    public TestTable(Integer id) {
        this.id = id;
    }

    /**
     * @hibernate.id
     *  generator-class="identity"
     *  type="java.lang.Integer"
     *  column="id"
     */
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    /** 
     * @hibernate.property
     *  column="hoge1"
     */
    public String getHoge1() {
        return this.hoge1;
    }

    public void setHoge1(String hoge1) {
        this.hoge1 = hoge1;
    }

    /** 
     * @hibernate.property
     *  column="hoge2"
     */
    public String getHoge2() {
        return this.hoge2;
    }

    public void setHoge2(String hoge2) {
        this.hoge2 = hoge2;
    }

    /** 
     * @hibernate.property
     *  column="hoge3"
     */
    public String getHoge3() {
        return this.hoge3;
    }

    public void setHoge3(String hoge3) {
        this.hoge3 = hoge3;
    }

    /**
     * @hibernate.property
     *   column = "create_date"     
     *   not-null = "false"
     */
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * @hibernate.property
     *   column = "update_date"     
     *   not-null = "false"
     */
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("id", getId())
            .toString();
    }
}
