/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao;

import java.util.Calendar;
import java.util.Date;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

/**
 * 基本データアクセスクラスです。 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public abstract class BaseDao extends SqlMapClientDaoSupport implements Dao {

    /**
     * <p>日付範囲検索の開始日として使用可能な当日の開始日時に変換します。</p>
     * <p>検索条件では<tt>xxxDate &gt;= :xxxDateFrom</tt>形式で指定します。</p>
     * @param value 変換する日付、または<tt>null</tt>
     * @return 日付範囲検索の開始日用の日付
     */
    protected Date toDateFrom(Date value) {
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        calendar.clear(Calendar.AM_PM);
        calendar.clear(Calendar.HOUR);
        calendar.clear(Calendar.HOUR_OF_DAY);
        calendar.clear(Calendar.MINUTE);
        calendar.clear(Calendar.SECOND);
        calendar.clear(Calendar.MILLISECOND);
        return calendar.getTime();
    }

    /**
     * <p>日付範囲検索の終了日として使用可能な翌日の開始日時に変換します。</p>
     * <p>検索条件では<tt>xxxDate &lt; :xxxDateTo</tt>形式で指定します。</p>
     * @param value 変換する日付、または<tt>null</tt>
     * @return 日付範囲検索の終了日用の日付
     */
    protected Date toDateTo(Date value) {
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        calendar.clear(Calendar.AM_PM);
        calendar.clear(Calendar.HOUR);
        calendar.clear(Calendar.HOUR_OF_DAY);
        calendar.clear(Calendar.MINUTE);
        calendar.clear(Calendar.SECOND);
        calendar.clear(Calendar.MILLISECOND);
        calendar.add(Calendar.DAY_OF_MONTH, 1);
        return calendar.getTime();
    }
}
