/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp;

/**
 * システムで発生した一般例外クラスです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class SampleException extends Exception {

	/**
	 * コンストラクタ
	 * @param message 例外メッセージ
	 */
	public SampleException(String message) {
		super(message);
	}

	/**
	 * コンストラクタ
	 * @param cause 例外
	 */
	public SampleException(Throwable cause) {
		super(cause);
	}

	/**
	 * コンストラクタ
	 * @param message 例外メッセージ
	 * @param cause 例外
	 */
	public SampleException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * コンストラクタ
	 * @param source 例外元オブジェクト
	 * @param cause 例外
	 */
	public SampleException(Object source, Throwable cause) {
		super(cause);
	}
}
