/*
 * Java Temlate Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.common.csv;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

import org.jtp.common.Encode;


/**
 * CSV出力ストリームを生成するクラスです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public final class CSVWriterFactory implements Encode {
    
    /** ファイル出力先 */
    private String path;

    /**
     * コンストラクタ
     * @param path ファイル出力先
     */
    public CSVWriterFactory(String path) {
        this.path = path;
    }
    
    /**
     * 出力ストリームを閉じる。
     * @param writer
     */
    public static void close(PrintWriter writer){
        if(writer != null){
            writer.close();
        }
    }

    /**
     * 出力ストリームを取得する
     * @return 出力ストリーム
     * @throws UnsupportedEncodingException サポート外のエンコーディング例外
     * @throws FileNotFoundException ファイル作成例外
     */
    public PrintWriter getWriter() throws UnsupportedEncodingException,
            FileNotFoundException {
        return getWriter(SJIS);
    }

    /**
     * 出力ストリームを取得する
     * @param encode エンコード
     * @return 出力ストリーム
     * @throws UnsupportedEncodingException サポート外のエンコーディング例外
     * @throws FileNotFoundException ファイル作成例外
     */
    public PrintWriter getWriter(String encode)
            throws UnsupportedEncodingException, FileNotFoundException {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(
                new FileOutputStream(this.path), encode)));
    } 
}
