/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.sample;

import java.io.Serializable;
import java.util.List;

import org.jtp.entity.TestTable;
import org.jtp.web.WebContext;



/**
 * サンプル画面のバッキングビーンクラスです。
 * 
 * @jsf.bean
 *  name = "sampleBean"
 *  scope = "session"
 * 
 * @jsf.navigation 
 *  result = "update" 
 *  from = "/sample/search.jsp" 
 *  to =   "/sample/update.tiles" 
 * @jsf.navigation 
 *  result = "remove" 
 *  from = "/sample/search.jsp" 
 *  to =   "/sample/remove.tiles" 
 * @jsf.navigation 
 *  result = "back" 
 *  from = "/sample/search.jsp" 
 *  to =   "/jsp/common/menu.jsp" 
 * 
 * @jsf.navigation 
 *  result = "remove" 
 *  from = "/sample/remove.jsp" 
 *  to   = "/sample/search.tiles" 
 * @jsf.navigation 
 *  result = "back" 
 *  from = "/sample/remove.jsp" 
 *  to   = "/sample/search.tiles" 
 * 
 * @jsf.navigation 
 *  result = "update" 
 *  from = "/sample/update.jsp" 
 *  to   = "/sample/search.tiles" 
 * @jsf.navigation 
 *  result = "back" 
 *  from = "/sample/update.jsp" 
 *  to   = "/sample/search.tiles" 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class SampleBean implements Serializable {

    public static final String ATTRIBUTE_NAME = "sampleBean";

    /** 検索条件 */
    private TestTable condition;

    /** テストテーブル情報 */
    private TestTable testTable;
    
    /** 検索結果情報を保持するクラスのリスト */
    private List searchList;
    
    /** 検索結果のエンティティリスト */
    private List testTableList;
    

    /**
     * コンストラクタ
     */
    public SampleBean() {
    	condition = new TestTable();
    }

    /**
	 * 検索条件を取得します。
	 * @return 検索条件
	 */
	public TestTable getCondition() {
		return condition;
	}

	/**
	 * 検索条件を設定します。
	 * @param condition 検索条件
	 */
	public void setCondition(TestTable condition) {
		this.condition = condition;
	}

	/**
	 * テストテーブル情報を取得します。
	 * @return テストテーブル情報
	 */
	public TestTable getTestTable() {
		return testTable;
	}

	/**
	 * テストテーブル情報を設定します。
	 * @param testTable テストテーブル情報
	 */
	public void setTestTable(TestTable testTable) {
		this.testTable = testTable;
	}

	/**
	 * 検索結果情報を保持するクラスのリストを取得します。
	 * @return 検索結果情報を保持するクラスのリスト
	 */
	public List getSearchList() {
		return searchList;
	}

	/**
	 * 検索結果情報を保持するクラスのリストを設定します。
	 * @param searchList 検索結果情報を保持するクラスのリスト
	 */
	public void setSearchList(List searchList) {
		this.searchList = searchList;
	}

	/**
	 * 検索結果のエンティティリストを取得します。
	 * @return 検索結果のエンティティリスト
	 */
	public List getTestTableList() {
		return testTableList;
	}

	/**
	 * 検索結果のエンティティリストを設定します。
	 * @param testTableList 検索結果のエンティティリスト
	 */
	public void setTestTableList(List testTableList) {
		this.testTableList = testTableList;
	}

	/**
	 * ダウンロード可能であるか確認します。
	 * @return true、false
	 */
	public boolean isDownload() {
		return ((searchList == null) || (searchList.isEmpty()));
	}
	
	/**
     * セッションにバインディングされているオブジェクトを返します。
     * @return バッキングビーン
     */
    public static SampleBean getBindingBean() {
        return (SampleBean) WebContext.getBindingBean(ATTRIBUTE_NAME);
    }
}
