/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.test;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.TestTable;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="testTableDao" 
 * @spring.property name="persistenceManagerFactory" ref="persistenceManagerFactory" 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class TestTableDaoImpl extends BaseDao implements TestTableDao {
	
	/**
	 * 検索します。
	 * @param testTable エンティティ
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
    public List find(TestTable testTable) throws SampleException {
    	Object[] values = {
    			toCondition(testTable.getId()),
    			toPartMatch(testTable.getHoge1()),
    			toPartMatch(testTable.getHoge2()),
    			toPartMatch(testTable.getHoge3())
    	};
    	Collection resultQuery = getJdoTemplate().findByNamedQuery(TestTable.class, "testTableList", values);
    	if (resultQuery.isEmpty()) {
    		return new ArrayList();
    	}
    	else {
    		List result = new ArrayList();
    		for (Iterator it = resultQuery.iterator(); it.hasNext();) {
    			result.add(it.next());
    		}
    		return result;
    	}
    }
    
	/**
	 * 登録します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(TestTable testTable) throws SampleException {
    	testTable.setCreateDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
    	testTable.setUpdateDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
    	getJdoTemplate().makePersistent(testTable);
    }

	/**
	 * 更新します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(TestTable testTable) throws SampleException {
    	Object object = getJdoTemplate().getObjectById(testTable.getClass(), testTable.getId());
    	((TestTable) object).setHoge1(testTable.getHoge1());
    	((TestTable) object).setHoge2(testTable.getHoge2());
    	((TestTable) object).setHoge3(testTable.getHoge3());
    	((TestTable) object).setUpdateDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
    	getJdoTemplate().evict(object);
    }
    
	/**
	 * 削除します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(TestTable testTable) throws SampleException {
    	Object object = getJdoTemplate().getObjectById(testTable.getClass(), testTable.getId());
    	getJdoTemplate().deletePersistent(object);
    }
}
