/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web;

import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.application.FacesMessage.Severity;

import org.jtp.web.util.FacesUtils;


/**
 * メッセージを表示するクラスです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public final class Message {

	/** 表示メッセージが登録メッセージであることを意味します */
	public static final String SAVED = "info.saved";
	
	/** 表示メッセージが更新メッセージであることを意味します */
	public static final String MODIFIED = "info.modified";
	
	/** 表示メッセージが削除メッセージであることを意味します */
	public static final String DELETED = "info.deleted";

	
    /**
     * コンストラクタ（外部からのインスタンス生成を許可しない）
     */
    private Message() {}

	/**
	 * INFOメッセージを表示します。
	 * @param arg1 メッセージのリソースキー
	 */
	public static void info(String arg1) {
		info(arg1);
	}
	
	/**
	 * INFOメッセージを表示します。
	 * @param arg1 メッセージのリソースキー
	 * @param arg2 メッセージに付加する値
	 */
	public static void info(String arg1, Object[] arg2) {
		addMessage(FacesMessage.SEVERITY_INFO, arg1, arg2);
	}
	
	/**
	 * WARNメッセージを表示します。
	 * @param arg1 メッセージのリソースキー
	 */
	public static void warn(String arg1) {
		warn(arg1);
	}
	
	/**
	 * WARNメッセージを表示します。
	 * @param arg1 メッセージのリソースキー
	 * @param arg2 メッセージに付加する値
	 */
	public static void warn(String arg1, Object[] arg2) {
		addMessage(FacesMessage.SEVERITY_WARN, arg1, arg2);
	}
	
	/**
	 * ERRORメッセージを表示します。
	 * @param arg1 メッセージのリソースキー
	 */
	public static void error(String arg1) {
		error(arg1);
	}
	
	/**
	 * ERRORメッセージを表示します。
	 * @param arg1 メッセージのリソースキー
	 * @param arg2 メッセージに付加する値
	 */
	public static void error(String arg1, Object[] arg2) {
		addMessage(FacesMessage.SEVERITY_ERROR, arg1, arg2);
	}
	
	/**
	 * FATALメッセージを表示します。
	 * @param arg1 メッセージのリソースキー
	 */
	public static void fatal(String arg1) {
		fatal(arg1);
	}
	
	/**
	 * FATALメッセージを表示します。
	 * @param arg1 メッセージのリソースキー
	 * @param arg2 メッセージに付加する値
	 */
	public static void fatal(String arg1, Object[] arg2) {
		addMessage(FacesMessage.SEVERITY_FATAL, arg1, arg2);
	}
	
	/**
	 * リストが0件の場合、メッセージを表示します。
	 * @param list
	 */
	public static void zero(List list) {
		if ((list == null) || (list.isEmpty())) {
			info("info.zero", null);
		}
	}

	/**
	 * メッセージを表示します。
	 * @param arg0 Severity
	 * @param arg1 メッセージのリソースキー
	 * @param arg2 メッセージに付加する値
	 */
	private static void addMessage(Severity arg0, String arg1, Object[] arg2) {
		FacesUtils.addMessage(arg0, arg1, arg2);
	}
}
