/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.sample;

import java.util.List;

import org.jtp.common.util.DateUtils;
import org.jtp.entity.TestTable;
import org.jtp.web.csv.CsvFactory;


/**
 * 利用ログCSVファイルを生成するクラスです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class SearchListCsvFactory extends CsvFactory {

	/**
	 * コンストラクタ
	 * @param list CSV出力するリストのオブジェクト
	 */
    public SearchListCsvFactory(List list) {
    	super(list);
    }
    
    /**
     * 出力行を作成する
     * @param object 出力情報オブジェクト
     * @return 出力行
     */
    protected String createRowString(Object object) {
    	TestTable testTable = (TestTable) object;
        StringBuffer sb = new StringBuffer();
        sb.append(testTable.getId());
        sb.append(DELIMITER + testTable.getHoge1());
        sb.append(DELIMITER + testTable.getHoge2());
        sb.append(DELIMITER + testTable.getHoge3());
        sb.append(DELIMITER + DateUtils.dateToString(testTable.getCreateDate()));
        sb.append(DELIMITER + DateUtils.dateToString(testTable.getUpdateDate()));
        return sb.toString();
    }
}
