/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.download;

import java.io.Serializable;

import org.jtp.web.csv.Factory;


/**
 * ダウンロード用のバッキングビーンクラスです。 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class DownloadBean implements Serializable {

	/** ダウンロードファイル名 */
	private String filename;
	/** ダウンロードファイル生成オブジェクト */
	private Factory factory;

	/**
	 * ダウンロードファイル名を取得する
	 * @return ダウンロードファイル名
	 */
	public String getFilename() {
		return filename;
	}

	/**
	 * ダウンロードファイル名を設定する
	 * @param filename ダウンロードファイル名
	 */
	public void setFilename(String filename) {
		this.filename = filename;
	}
	
	/**
	 * ダウンロードファイル生成オブジェクトを取得する
	 * @return ダウンロードファイル生成オブジェクト
	 */
	public Factory getFactory() {
		return factory;
	}

	/**
	 * ダウンロードファイル生成オブジェクトを設定する
	 * @param factory ダウンロードファイル生成オブジェクト
	 */
	public void setFactory(Factory factory) {
		this.factory = factory;
	}
}
