/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.sample;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorActionForm;
import org.jtp.SampleException;
import org.jtp.entity.TestTable;
import org.jtp.logic.test.TestTableService;
import org.jtp.web.action.BaseAction;

/**
 * 削除画面アクションクラスです。
 * 
 * @struts.action
 *  name="sample/InputForm"
 *  path="/sample/remove"
 *  scope="request"
 *  validate="true"
 *  input="/sample/remove.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="success"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/sample/search.tiles"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class RemoveAction extends BaseAction {

    /** テストテーブル情報サービス */
    private TestTableService testTableService;

    
    /**
     * テストテーブル情報サービスを設定します。
     * @param testTableService テストテーブル情報サービス
     */
	public void setTestTableService(TestTableService testTableService) {
		this.testTableService = testTableService;
	}

	/**
	 * 削除アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward success(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {

		DynaValidatorActionForm dyna = (DynaValidatorActionForm) form;

		TestTable testTable = new TestTable();
		testTable.setId(new Integer(request.getParameter("id")));
		testTable.setHoge1(dyna.getString("hoge1"));
		testTable.setHoge2(dyna.getString("hoge2"));
		testTable.setHoge3(dyna.getString("hoge3"));
		
		testTableService.delete(testTable);
		
		getSession(request).setAttribute("list", testTableService.find(new TestTable()));
		
		return mapping.findForward(request.getParameter(FORWARD_EVENT));
	}
}
