/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.apache.tapestry;

import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xjavadoc.XClass;

/**
 * Generates page-specifications for Tapestry applications.
 *
 * @author        Michael Newcomb (mnewcomb@sourceforge.net)
 * @created       February 4, 2005
 * @version       $Revision: 1.2 $
 * @ant.element   name="page-specification" display-name="Page-Specification SubTask"
 *      parent="xdoclet.modules.apache.tapestry.TapestryDocletTask"
 */
public class PageSpecificationSubTask extends TemplateSubTask
{
    protected final static String DEFAULT_TEMPLATE_FILE = "resources/page-specification.xdt";

    /**
     */
    public PageSpecificationSubTask()
    {
        setTemplateURL(getClass().getResource(DEFAULT_TEMPLATE_FILE));
        setDestinationFile("{0}.page");
        setPrefixWithPackageStructure(false);
    }

    /**
     * Describe what the method does
     *
     * @param clazz                 Describe what the parameter does
     * @return                      Describe the return value
     * @exception XDocletException
     */
    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException
    {
        return clazz.getDoc().getTag("tapestry:page-specification") != null;
    }
}
