/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.form;

import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorActionForm;

/**
 * アクションフォームクラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public abstract class BaseActionForm extends DynaValidatorActionForm {

	/**
	 * HTTPリクエストにセットされているプロパティの妥当性を検証して、
	 * 見つかった全ての検証エラーをカプセル化した ActionErrorsオブジェクトを返します。
	 * エラーが見つからなかった場合はnullもしくはエラーメッセージが何も記録されていない
	 * ActionErrorsオブジェクトを返します。
	 * @param mapping このインスタンスを選択するために使用したActionMapping
	 * @param request 処理しているHTTPリクエスト
	 * @return ActionErrorsオブジェクト
	 */
	@Override
	public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		
        //妥当性の検証を行うか確認します
        if (!isValidate(mapping, request)) {
            return new ActionErrors();
        }

		//関連付けられたプロパティの妥当性を検証する
		ActionErrors errors = super.validate(mapping, request);
		
		//固有の検証を行います
		errors.add(doValidate(mapping, request));
		
		//エラーがある場合
		if (!errors.isEmpty()) {
			//画面内容をリクエストに設定する
			requestFormProperty(request);
		}
		else {
	        //リクエストパラメータ値を、このフォームへ設定します
	        copyParameters(request);
		}
		
		return errors;
	}
	  
    /**
     * リクエストパラメータ値を、このフォームへ設定します。
     * @param request 処理しているHTTPリクエスト
     */
    protected void copyParameters(HttpServletRequest request) {
        try {
            for (Iterator it = this.getMap().keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                //このフォームのプロパティがStringのみ対象とする
                if (!this.getDynaProperty(key).getType().equals(String.class)) continue;
                String value = request.getParameter(key);
                if (StringUtils.isEmpty(value)) continue;
                PropertyUtils.setProperty(this, key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 妥当性の検証を行うか確認します
     * @param mapping このインスタンスを選択するために使用したActionMapping
     * @param request 処理しているHTTPリクエスト
     * @return true[行う]、false[行わない]
     */
    protected boolean isValidate(ActionMapping mapping, HttpServletRequest request) {
        return true;
    }

    /**
     * 妥当性を検証します
     * @param mapping このインスタンスを選択するために使用したActionMapping
     * @param request 処理しているHTTPリクエスト
     * @return ActionErrorsオブジェクト
     */
    protected ActionErrors doValidate(ActionMapping mapping, HttpServletRequest request) {
    	return new ActionErrors();
    }
    
	/**
	 * 妥当性の検証エラーがある場合、画面内容をリクエストに設定する
	 * @param request 処理しているHTTPリクエスト
	 */
	protected abstract void requestFormProperty(HttpServletRequest request);
}
