/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.form;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.jtp.web.WebConstants;

/**
 * アクションフォームクラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class MailAddressActionForm extends BaseActionForm {

    /**
     * 妥当性の検証を行うか確認します
     * @param mapping このインスタンスを選択するために使用したActionMapping
     * @param request 処理しているHTTPリクエスト
     * @return true[行う]、false[行わない]
     */
	@Override
	protected boolean isValidate(ActionMapping mapping, HttpServletRequest request) {
		return "save".equals(request.getParameter(WebConstants.FORWARD_EVENT));
	}
	
	/**
	 * 妥当性の検証エラーがある場合、画面内容をリクエストに設定する
	 * @param request 処理しているHTTPリクエスト
	 */
	@Override
	protected void requestFormProperty(HttpServletRequest request) {}
}
