/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.form;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.upload.FormFile;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.web.bean.SendMailBean;

/**
 * アクションフォームクラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class SendActionForm extends BaseActionForm {
	
	/** 添付ファイルの最大サイズであることを意味します */
	private static final int FILE_MAX_SIZE = 65535;
	
    /**
     * 妥当性を検証します
     * @param mapping このインスタンスを選択するために使用したActionMapping
     * @param request 処理しているHTTPリクエスト
     * @return ActionErrorsオブジェクト
     */
	@Override
    protected ActionErrors doValidate(ActionMapping mapping, HttpServletRequest request) {
    	ActionErrors errors = super.doValidate(mapping, request);
    	
		FormFile[] files = (FormFile[]) get("attachment");
		for (int i = 0; i < files.length; i++) {
			if (StringUtils.isEmpty(files[i].getFileName())) continue;
			try {
				byte[] data = files[i].getFileData();
				if (data.length > FILE_MAX_SIZE) {
					errors.add("errors.msg", new ActionMessage("msg.maxFileSize"));
				}
			}
			catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
		
		return errors;
    }
	
	/**
	 * 妥当性の検証エラーがある場合、画面内容をリクエストに設定する
	 * @param request 処理しているHTTPリクエスト
	 */
	@Override
	protected void requestFormProperty(HttpServletRequest request) {
		SendMailBean sendMailBean = new SendMailBean();
		PropertyUtilsWrapper.copyProperties(getMap(), sendMailBean);
		request.setAttribute("sendMailBean", sendMailBean);
	}
}
