/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity.mail;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.jtp.entity.AuditableEntity;


/**
 * アカウントテーブルのエンティティクラスです。
 * 
 * @hibernate.class
 *  table="mail_account_table"
 *  mutable = "true"
 *  lazy = "false"
 * 
 * @hibernate.mapping
 *  auto-import = "true"
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class MailAccountTable extends AuditableEntity {

    /** identifier field */
    private Integer id;

    /** nullable persistent field */
    private String name;

    /** nullable persistent field */
    private String address;


    /** default constructor */
    public MailAccountTable() {
    }

    /** minimal constructor */
    public MailAccountTable(Integer id) {
        this.id = id;
    }

    /**
     * @hibernate.id
     *  generator-class="identity"
     *  column="id"
     */
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    /** 
     * @hibernate.property
     *  column="name"
     */
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /** 
     * @hibernate.property
     *  column="address"
     */
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", getId()).toString();
    }
}
