/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity.mail;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jtp.entity.AuditableEntity;


/**
 * BCCメールテーブルのエンティティクラスです。
 * 
 * @hibernate.class
 *  table="mail_bcc_table"
 *  mutable = "true"
 *  lazy = "false"
 * 
 * @hibernate.mapping
 *  auto-import = "true"
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class MailBccTable extends AuditableEntity {

    /** identifier field */
    private MailBccTablePK id;

    /** nullable persistent field */
    private String bcc;


    /** default constructor */
    public MailBccTable() {
    }

    /** minimal constructor */
    public MailBccTable(MailBccTablePK id) {
        this.id = id;
    }

    /**
     * @hibernate.id
     */
    public MailBccTablePK getId() {
        return this.id;
    }

    public void setId(MailBccTablePK id) {
        this.id = id;
    }

    /** 
     * @hibernate.property
     *  column="bcc"
     */
    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", getId()).toString();
    }

    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof MailBccTable) ) return false;
        MailBccTable castOther = (MailBccTable) other;
        return new EqualsBuilder()
            .append(this.getId(), castOther.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

}
