/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.mail;

import java.util.Set;

import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.mail.MailBccTable;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="mailBccTableDao" 
 * @spring.property name="sessionFactory" ref="sessionFactory" 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class MailBccTableDaoImpl extends BaseDao implements MailBccTableDao {
    
	/**
	 * 登録します。
	 * @param mailBccTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailBccTable mailBccTable) throws SampleException {
    	getHibernateTemplate().save(mailBccTable);
    }
    
	/**
	 * 登録します。
	 * @param mailBccSet エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(Set mailBccSet) throws SampleException {
    	getHibernateTemplate().saveOrUpdateAll(mailBccSet);
    }
}
