/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.form;

import javax.servlet.http.HttpServletRequest;

import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.test.TestTable;
import org.jtp.entity.test.TestTableDetail;
import org.jtp.entity.test.TestTableDetailPK;

/**
 * アクションフォームクラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class SampleUpdateActionForm extends SampleActionForm {
	
	/**
	 * 妥当性の検証エラーがある場合、画面内容をリクエストに設定する
	 * @param request 処理しているHTTPリクエスト
	 */
	protected void requestFormProperty(HttpServletRequest request) {
		super.requestFormProperty(request);
		TestTableDetail testTableDetail = new TestTableDetail();
		PropertyUtilsWrapper.copyProperties(getMap(), testTableDetail);
		TestTable testTable = (TestTable) request.getAttribute("testTable");
		testTableDetail.setCompId(new TestTableDetailPK(testTable.getId(), new Integer(1)));
		testTableDetail.setCreateDate(testTable.getCreateDate());
		request.setAttribute("testTableDetail", testTableDetail);
	}
}
