/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.report;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

import javax.servlet.ServletContext;

/**
 * 帳票データ生成を提供するインターフェースです。 
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public interface ReportGenerator {

	/**
     * PDF出力情報オブジェクトを保持したコレクションを生成する
     * @param object 申込バッキングビーン
     * @param context サーブレットコンテキスト
     * @return PDF出力情報オブジェクトを保持したコレクション
     * @throws IOException I/O例外
     */
    public InputStream generate(ServletContext context, Collection collection) throws IOException;
}
