#[名称]jude2ruby
#[機能]JUDE/Communityが出力するJavaのスケルトンファイルをRubyのスケルトンファイルに変換
#[使用方法]Javaスケルトンファイルのあるフォルダにjude2ruby.rbを置き実行する
#
#[改訂履歴]
#Date       Ver  Name     Comment
#2007/10/09 0.00 hantani  new
#2007/10/10 0.01 hantani  インスタンス変数をinitialize関数内で宣言するよう変更
#2007/10/10 0.02 hantani  unit testのスケルトンも出力するよう変更(全テスト実行用runner.rb付き)
#2007/10/10 0.03 hantani  最初の行を追加。サブフォルダの処理をやめる（テストスケルトン作成が難しくなるため）
#                         logger出力を追加（オプションでOFFも可）

require 'logger'
require 'kconv'
require 'FileUtils'

class MyProperty
  attr_accessor :access, :type, :name

  TypePrivate = "private"
  TypePublic = "public"

  def initialize(access,type,name)
    @access = access
    @type = type
    @name = name
  end
end

class MyMethod
  attr_accessor :access, :type, :name,:argument

  TypePrivate = "private"
  TypePublic = "public"

  def initialize(access,type,name)
    @access = access
    @type = type
    @name = name
    @argument=[]
  end
  def addArgument(arg)
    @argument << arg
  end
end

class RubyClass
  attr_accessor :className, :property, :method, :extends
  def initialize
    @className=""
    @property=[]
    @method=[]
    @extends=[]
    @logger = logger || Logger.new(STDERR)
#    @logger.level = Logger::DEBUG
    @logger.level = Logger::WARN
  end
  attr_reader :logger
  def analyze(line)
    if /class\s+(\S+).*\{$/=~ line #class name
      @className = $1
      @logger.debug "RubyClass:className=#{@className}"
      if /class\s+(\S+)\s*extends\s+([^\{]+)\{$/=~ line #extends name
        cls = $2.split(",")
        cls.each {|c| @extends << c.strip}
        @extends.each{|ex|@logger.debug "RubyClass:extends=#{ex}"}
      end
    end
    if /\s*(\S+)\s+(\S+)\s+(\S+)\s*;/ =~ line #propaty
      prp=MyProperty.new($1,$2,$3)
      @property << prp
      @logger.debug "RubyClass:property=#{$1},#{$2},#{$3}"
    end    
    if /\s*(\S+)\s+(\S+)\s+(\S+)\s*\(([^\)]*)\)\s+\{/ =~ line #method
      met = MyMethod.new($1,$2,$3)
      @logger.debug "RubyClass:method=#{$1},#{$2},#{$3}"
      if $4 != "" then
        prm = $4.split(",")
        prm.each {|c|
          d = c.split(" ")
          met.argument << d[1].strip
        }
      end
      @method << met
    end
  end
  def getMethod(name)
    @method.each {|met|
      if met.name == name then
        return met
      end
    }
    return nil
  end
end
class Jude2ruby
  Initialize="initialize"
  UnitTestDirectory="test"
  UseBinEnv = "#!/usr/bin/env ruby\n"

  attr_accessor :rubyClass,:optionAddLogger

  def initialize(logger = nil)
    @logger = logger || Logger.new(STDERR)
#    @logger.level = Logger::DEBUG
    @logger.level = Logger::WARN
    @optionAddLogger = nil  #nil:not add logger,else:add logger
  end
  attr_reader :logger
  def readfile(file)
    @rubyClass=RubyClass.new
    f=File.open(file)
    while line = f.gets
      if line then
        line = Kconv.toutf8(line)
        @rubyClass.analyze(line)
      end
    end
    f.close
  end
  def writefile(file)
    wrfile = File.dirname(file) + "/" + File.basename(file, ".*") + ".rb"
    @logger.debug "w:#{wrfile}"
    f = File.open(wrfile,"w")
    f.puts(convert)
    f.close
  end
  def convert

    strRequire=""
    strClassName=""
    strAttr=""
    strProperty=""
    strMethod=""
    strInitializeMethod=""

    if @optionAddLogger != nil then
      strRequire = getLogger(:HEADER)
    end

    c = @rubyClass.className

    if c[0..0] != c[0..0].upcase then
      msg = "#{@rubyClass.className} :class/module name must be CONSTANT"
      @logger.error msg
      return msg
    end

    strClassName = "class #{c}"

    if @rubyClass.extends.size > 0 then
      e = @rubyClass.extends[0]
      if e[0..0] != e[0..0].upcase then
        msg = "#{e} :class/module name must be CONSTANT"
        @logger.error msg
        return msg
      end
      strClassName = strClassName + " < #{@rubyClass.extends[0]}"
      strRequire = strRequire + "require '#{@rubyClass.extends[0]}'\n"
    end

    pubPrp = ""
    prvPrp = ""
    @rubyClass.property.each {|prp|
      if /(\S+)\[\]/=~ prp.type then
        strRequire = strRequire + "require '#{$1}'\n"
      end
      
      if prp.access == MyProperty::TypePrivate then
        prvPrp = prvPrp + "\t\t@#{prp.name}\n"
      end
      if prp.access == MyProperty::TypePublic then
        if pubPrp == "" then
          pubPrp = pubPrp + ":#{prp.name}"
        else
          pubPrp = pubPrp + ",:#{prp.name}"
        end
        prvPrp = prvPrp + "\t\t@#{prp.name}\n"
      end
    }
    if pubPrp != "" then
      strAttr = "\tattr_accessor " + pubPrp + "\n"
    end
    if prvPrp != "" then
      strProperty = prvPrp
    end

    pubMet = ""
    prvMet = ""
    @rubyClass.method.each {|met|
      m = ""
      met.argument.each{|arg|
        if m == "" then
          m = m + arg
        else
          m = m + "," + arg
        end
      }
      if not m then
        m = ""
      end
      m = "\tdef #{met.name}(" + m + ")\n"
      @logger.debug "met.access #{met.access}" 
      @logger.debug "met.access #{MyMethod::TypePrivate}"
      @logger.debug "met.access #{MyMethod::TypePublic}"

      if Initialize == met.name then
        strInitializeMethod = m
      else
        m = m + "\tend\n\n"
        if met.access == MyMethod::TypePrivate then
          prvMet = prvMet + m
          @logger.debug "prvMet #{m}"
        end
        if met.access == MyMethod::TypePublic then
          pubMet = pubMet + m
          @logger.debug "pubMet #{m}"
        end
      end
    }
    strMethod = pubMet
    if prvMet != "" then
      strMethod = strMethod + "\tprivate\n\n"
      strMethod = strMethod + prvMet
    end

    if strInitializeMethod == "" then
      strInitializeMethod = "\tdef #{Initialize}\n"
    end

    strInitializeMethod = strInitializeMethod + strProperty 
    if @optionAddLogger != nil then
      strInitializeMethod = strInitializeMethod + getLogger(:DEFINE)
    end    
    strInitializeMethod = strInitializeMethod + "\tend\n"

    s = UseBinEnv + "\n" + strRequire + "\n" + addComment + strClassName + "\n" + strAttr  + "\n" + strInitializeMethod + "\n" + strMethod + "end"

  end

  def makeUnitTestFilename(file)
    return  "test_" + File.basename(file, ".*") + ".rb"
  end

  def makeUnitTestDirectory
    FileUtils.mkdir("./" + UnitTestDirectory) rescue puts "dir is exist"
  end

  def makeUnitTest(file)

    strRequire=""
    strClassName=""
    strAttr=""
    strProperty=""
    strMethod=""
    strInitializeMethod=""

    strRequire = "require 'test/unit'\n"
    strRequire = strRequire + "require '../#{@rubyClass.className}'\n"
    
    strClassName = addComment + "class Test_#{@rubyClass.className} < Test::Unit::TestCase"
    strMethod = "\tdef setup\n\t\t@obj = #{@rubyClass.className}.new"
    initializeMethod = @rubyClass.getMethod(Initialize)
    if initializeMethod != nil then
      arg = ""
      initializeMethod.argument.each{|initarg|
        if arg == "" then
          arg = "nil"
        else
          arg = arg + ",nil"
        end
      }
      strMethod = strMethod +"(" + arg + ")"
    end
    strMethod = strMethod +"\n\tend\n"
    strMethod = strMethod +"\n\tdef teardown\n\tend\n\n"

    @rubyClass.method.each {|met|
      strMethod = strMethod +  "\tdef test_#{met.name}()\n\tend\n\n"
    }
    s =  UseBinEnv + "\n" + "$LOAD_PATH << File.dirname(__FILE__) + '/..'\n"
    s = s + strRequire + "\n" + strClassName + "\n" + strAttr  + "\n" + strInitializeMethod + "\n" + strMethod + "end"

    makeUnitTestDirectory
    f=File.open("./#{UnitTestDirectory}/#{makeUnitTestFilename(file)}","w")
    f.puts s
    f.close

    f=File.open("./#{UnitTestDirectory}/runner.rb","w")
    f.puts "require 'test/unit'\n\tTest::Unit::AutoRunner.run(true, '.')\n\tputs 'Press [ENTER] to exit'\n\ts=gets\n"
    f.close

  end
  
  def addComment
    s ="#Authors::   \n"
    s = s + "#Version::   0.00\n"
    s = s + "#Copyright:: Copyright (C) xxx, 2007. All rights reserved.\n"
    s = s + "#License::   Ruby License\n"
  end

  def getLogger(opt)
    case opt
      when :HEADER
        return "require 'logger'\n"
      when :DEFINE
        return "\t\t@logger = Logger.new(STDERR)\n\t\t@logger.level = Logger::DEBUG\n"
    end
  end


  def main(file)
    readfile(file)
    @optionAddLogger = "ON"
    writefile(file)
    makeUnitTest(file)
  end
end


j2r=Jude2ruby.new
Dir.glob("*.java") do |file|
  j2r.main(file)
end
 