require 'test/unit'
require '../jude2ruby'

	def file_test(file1,file2)
		f1=File.open(file1)
		f2=File.open(file2)

		while line1=f1.gets
			line2=f2.gets
			assert_equal(line2,line1)
		end
		f1.close
		f2.close
  end

class Test_Jude2ruby < Test::Unit::TestCase
  def setup
		f=File.open("dummy.java","w")
		f.print <<EOF
public class Class2 extends Class3 {
	public int property4;
	private Class4[] class4;
	public int method3(int param4, int param5, int param6) {
		return 0;
	}
	private void method4(int param7, int param8) {
	}
}
EOF
		f.close

		f=File.open("dummy1.java","w")
		f.print <<EOF
public class Class5 extends Class6 {
	public int property5;
	private Class2[] class2;
	public int method5(int param5, int param6, int param7) {
		return 0;
	}
	private void method6(int param8, int param9) {
	}
	private void initialize(int param10, int param11) {
	}
}
EOF
		f.close

		f=File.open("converted.rb","w")
		f.print <<EOF
#!/usr/bin/env ruby

require 'logger'
require 'Class3'
require 'Class4'

#Authors::   
#Version::   0.00
#Copyright:: Copyright (C) xxx, 2007. All rights reserved.
#License::   Ruby License
class Class2 < Class3
	attr_accessor :property4

	def initialize
		@property4
		@class4
		@logger = Logger.new(STDERR)
		@logger.level = Logger::DEBUG
	end

	def method3(param4,param5,param6)
	end

	private

	def method4(param7,param8)
	end

end
EOF
		f.close

		f=File.open("converted1.rb","w")
		f.print <<EOF
#!/usr/bin/env ruby

require 'logger'
require 'Class6'
require 'Class2'

#Authors::   
#Version::   0.00
#Copyright:: Copyright (C) xxx, 2007. All rights reserved.
#License::   Ruby License
class Class5 < Class6
	attr_accessor :property5

	def initialize(param10,param11)
		@property5
		@class2
		@logger = Logger.new(STDERR)
		@logger.level = Logger::DEBUG
	end

	def method5(param5,param6,param7)
	end

	private

	def method6(param8,param9)
	end

end
EOF
		f.close

		f=File.open("unittest.rb","w")
		f.print <<EOF
#!/usr/bin/env ruby

$LOAD_PATH << File.dirname(__FILE__) + '/..'
require 'test/unit'
require '../Class2'

#Authors::   
#Version::   0.00
#Copyright:: Copyright (C) xxx, 2007. All rights reserved.
#License::   Ruby License
class Test_Class2 < Test::Unit::TestCase


	def setup
		@obj = Class2.new
	end

	def teardown
	end

	def test_method3()
	end

	def test_method4()
	end

end
EOF
		f.close

		@myProperty=MyProperty.new("private","int","test")
		@myMethod=MyMethod.new("public","char","func")
		@rubyClass=RubyClass.new
    @jude2ruby = Jude2ruby.new
  end
  
  def test_MyProperty
    assert_equal(MyProperty::TypePrivate,@myProperty.access)
    assert_equal("int",@myProperty.type)
    assert_equal("test",@myProperty.name)
		@myProperty.access = "public"
    assert_equal(MyProperty::TypePublic,@myProperty.access)
  end

  def test_MyMethod
    assert_equal(MyMethod::TypePublic,@myMethod.access)
    assert_equal("char",@myMethod.type)
    assert_equal("func",@myMethod.name)
		@myMethod.access = "private"
    assert_equal(MyMethod::TypePrivate,@myMethod.access)
		@myMethod.addArgument("arg1")
		@myMethod.addArgument("arg2")
    assert_equal("arg1",@myMethod.argument[0])
    assert_equal("arg2",@myMethod.argument[1])
  end

  def test_RubyClass
		@rubyClass.analyze("public class Class1 extends Class0 {")
    assert_equal("Class1",@rubyClass.className)
    assert_equal("Class0",@rubyClass.extends[0])
		@rubyClass.analyze("	public int property3;")
    assert_equal("public",@rubyClass.property[0].access)
    assert_equal("int",@rubyClass.property[0].type)
    assert_equal("property3",@rubyClass.property[0].name)

		@rubyClass.analyze("	public int method2(int param3, int param4, int param5) {")
    assert_equal("public",@rubyClass.method[0].access)
    assert_equal("int",@rubyClass.method[0].type)
    assert_equal("method2",@rubyClass.method[0].name)
    assert_equal("param3",@rubyClass.method[0].argument[0])
    assert_equal("param4",@rubyClass.method[0].argument[1])
    assert_equal("param5",@rubyClass.method[0].argument[2])

		@rubyClass.analyze("	private void method3(int param6, int param7) {")
    assert_equal("private",@rubyClass.method[1].access)
    assert_equal("void",@rubyClass.method[1].type)
    assert_equal("method3",@rubyClass.method[1].name)
    assert_equal("param6",@rubyClass.method[1].argument[0])
    assert_equal("param7",@rubyClass.method[1].argument[1])
  end

	def test_Jude2ruby

		@jude2ruby.readfile("dummy.java")
	  assert_equal("Class2",@jude2ruby.rubyClass.className)
	  assert_equal("Class3",@jude2ruby.rubyClass.extends[0])

    assert_equal("public",@jude2ruby.rubyClass.property[0].access)
    assert_equal("int",@jude2ruby.rubyClass.property[0].type)
    assert_equal("property4",@jude2ruby.rubyClass.property[0].name)

    assert_equal("public",@jude2ruby.rubyClass.method[0].access)
    assert_equal("int",@jude2ruby.rubyClass.method[0].type)
    assert_equal("method3",@jude2ruby.rubyClass.method[0].name)
    assert_equal("param4",@jude2ruby.rubyClass.method[0].argument[0])
    assert_equal("param5",@jude2ruby.rubyClass.method[0].argument[1])
    assert_equal("param6",@jude2ruby.rubyClass.method[0].argument[2])

    assert_equal("private",@jude2ruby.rubyClass.method[1].access)
    assert_equal("void",@jude2ruby.rubyClass.method[1].type)
    assert_equal("method4",@jude2ruby.rubyClass.method[1].name)
    assert_equal("param7",@jude2ruby.rubyClass.method[1].argument[0])
    assert_equal("param8",@jude2ruby.rubyClass.method[1].argument[1])

		@jude2ruby.rubyClass.className="class2"
		assert_equal("class2 :class/module name must be CONSTANT",@jude2ruby.convert)

		@jude2ruby.readfile("dummy.java")
    @jude2ruby.optionAddLogger = "ON"
		@jude2ruby.writefile("convtest.rb")

    file_test("convtest.rb","converted.rb")

		@jude2ruby.main("dummy.java")
    file_test("dummy.rb","converted.rb")

		@jude2ruby.main("dummy1.java")
    file_test("dummy1.rb","converted1.rb")
	end

	def test_makeUnitTestFilename
		assert_equal("test_testfunc.rb",@jude2ruby.makeUnitTestFilename("testfunc.java"))
	end
  
	def test_makeUnitTest
     file_test("unittest.rb","./test/test_dummy.rb")
  end

	def test_addComment
		s ="#Authors::   \n"
		s = s + "#Version::   0.00\n"
		s = s + "#Copyright:: Copyright (C) xxx, 2007. All rights reserved.\n"
		s = s + "#License::   Ruby License\n"
     assert_equal(s,@jude2ruby.addComment)
  end

	def test_getLogger
		assert_equal("require 'logger'\n",@jude2ruby.getLogger(:HEADER))
		assert_equal("\t\t@logger = Logger.new(STDERR)\n\t\t@logger.level = Logger::DEBUG\n",@jude2ruby.getLogger(:DEFINE))
  end



  
  
end
