/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* rdhmmdef_trans.c --- read in hmmdefs (transition) */

/* $Id: rdhmmdef_trans.c,v 1.3 2002/09/11 22:01:50 ri Exp $ */

/* read data is linear scale (will be converted later) */

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>

extern char *rdhmmdef_token;	/* defined in rdhmmdef.c */

/* malloc new */
static HTK_HMM_Trans *
trans_new()
{
  HTK_HMM_Trans *new;

  new = (HTK_HMM_Trans *)mybmalloc(sizeof(HTK_HMM_Trans));
  new->name = (char *)NULL;
  new->statenum = 0;
  new->a = (PROB **)NULL;
  new->next = NULL;
  
  return(new);
}

/* register */
static void
trans_add(HTK_HMM_INFO *hmm, HTK_HMM_Trans *new)
{
  HTK_HMM_Trans *match;

  /* link data structure */
  new->next = hmm->trstart;
  hmm->trstart = new;

  if (new->name != NULL) {
    /* add index to search index tree */
    if (hmm->tr_root == NULL) {
      hmm->tr_root = aptree_make_root_node(new);
    } else {
      match = aptree_search_data(new->name, hmm->tr_root);
      if (strmatch(match->name,new->name)) {
	j_printerr("Error: ~t \"%s\" is already defined\n", new->name);
	rderr(NULL);
      } else {
	aptree_add_entry(new->name, new, match->name, &(hmm->tr_root));
      }
    }
  }
}  

/* lookup by name */
static HTK_HMM_Trans *
trans_lookup(HTK_HMM_INFO *hmm, char *keyname)
{
  HTK_HMM_Trans *t;

  t = aptree_search_data(keyname, hmm->tr_root);
  if (strmatch(t->name, keyname)) {
    return t;
  } else {
    return NULL;
  }
}

/* read in transition data and return new (malloced) HTK_HMM_Trans */
static HTK_HMM_Trans *
trans_read(FILE *fp)
{
  HTK_HMM_Trans *new;
  int i,j;
  PROB prob;
  PROB *atmp;

  /* read tag */
  if (!currentis("TRANSP")) rderr("<TRANSP> not found"); /* not match */
  read_token(fp);

  /* read statenum */
  new = trans_new();
  NoTokErr("missing TRANSP state num");
  new->statenum = atoi(rdhmmdef_token);
  read_token(fp);

  /* allocate array */
  new->a = (PROB **)mybmalloc(sizeof(PROB *) * new->statenum);
  atmp = (PROB *)mybmalloc(sizeof(PROB) * new->statenum * new->statenum);
  new->a[0] = &(atmp[0]);
  for (i=1;i<new->statenum;i++) {
    new->a[i] = &(atmp[i*new->statenum]);
  }
  
  /* begin reading transition prob */
  for (i=0;i<new->statenum; i++) {
    for (j=0;j<new->statenum; j++) {
      NoTokErr("missing some TRANSP value");
      prob = atof(rdhmmdef_token);
      new->a[i][j] = prob;
      read_token(fp);
    }
  }

  return(new);
}

/* read in transition data at the current point, and
   return pointer to the data */
HTK_HMM_Trans *
get_trans_data(FILE *fp, HTK_HMM_INFO *hmm)
{
  HTK_HMM_Trans *tmp;
  
  if (currentis("TRANSP")) {
    /* definition: define transition data, and return the pointer */
    tmp = trans_read(fp);
    tmp->name = NULL; /* no name */
    trans_add(hmm, tmp);
    return(tmp);
  } else if (currentis("~t")) {
    /* macro reference: lookup and return the pointer */
    read_token(fp);
    NoTokErr("missing TRANSP macro name");
    tmp = trans_lookup(hmm, rdhmmdef_token);
    if (tmp == NULL) {
      j_printerr("~t \"%s\" not defined\n", rdhmmdef_token);
      rderr(NULL);
    }
    read_token(fp);
    return(tmp);
  } else {
    rderr("no transition data");
    return(NULL);
  }
}

/* define transition data */
void
def_trans_macro(char *name, FILE *fp, HTK_HMM_INFO *hmm)
{
  HTK_HMM_Trans *new;

  /* read in data and return newly malloced data */
  new = trans_read(fp);

  /* register it to the grobal HMM structure */
  new->name = name;
  trans_add(hmm, new);
}
