/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* endian.c --- byte swapping for different endian architecture */

/* $Id: endian.c,v 1.3 2002/09/11 22:01:50 ri Exp $ */

#include <sent/stddefs.h>

/* generic byte-swap function */
void
swap_bytes(char *buf, size_t unitbyte, int unitnum)
{
  char *p, c;
  int i, j;

  p = buf;
  while (unitnum > 0) {
    i=0; j=unitbyte-1;
    while(i<j) {
      c = p[i]; p[i] = p[j]; p[j] = c;
      i++;j--;
    }
    p += unitbyte;
    unitnum--;
  }
}

/* swap bytes for SP16short */
void
swap_sample_bytes(SP16 *buf, int len)
{
  char *p;
  char t;
  int i;
  
  p = (char *)buf;

  for (i=0;i<len;i++) {
    t = *p;
    *p = *(p + 1);
    *(p + 1) = t;
    p += 2;
  }
}
