/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* extern.h --- external functions prototype definitions */

/* $Id: extern.h,v 1.8 2002/11/06 16:56:41 ri Exp $ */

/* should be included after all include files */

/* backtrellis.c */
void bt_init(BACKTRELLIS *bt);
void bt_prepare(BACKTRELLIS *bt);
void bt_store(BACKTRELLIS *bt, TRELLIS_ATOM *aotm);
void bt_relocate_rw(BACKTRELLIS *bt);
#ifdef SP_BREAK_CURRENT_FRAME
void set_terminal_words(BACKTRELLIS *bt);
#endif
void bt_sort_rw(BACKTRELLIS *bt);
TRELLIS_ATOM *bt_binsearch_atom(BACKTRELLIS *bt, int time, WORD_ID wkey);

/* factoring_sub.c */
void make_iwcache_index(WCHMM_INFO *wchmm);
#ifndef CATEGORY_TREE
void make_sc_index(WCHMM_INFO *wchmm);
#endif
void make_successor_list(WCHMM_INFO *wchmm);
#ifdef USE_NGRAM
void max_successor_cache_init(WCHMM_INFO *wchmm);
void max_successor_cache_free(void);
LOGPROB max_successor_prob(WCHMM_INFO *wchmm, WORD_ID lastword, int node);
LOGPROB *max_successor_prob_iw(WCHMM_INFO *wchmm, WORD_ID lastword);
void  calc_all_unigram_factoring_values(WCHMM_INFO *wchmm);
#ifdef CLASS_NGRAM
void make_class_ref(NGRAM_INFO *w, WORD_INFO *v);
LOGPROB class_uni_prob(NGRAM_INFO *ndata, WORD_ID w);
LOGPROB class_bi_prob_lr(NGRAM_INFO *ndata, WORD_ID w1, WORD_ID w2);
LOGPROB class_bi_prob_rl(NGRAM_INFO *ndata, WORD_ID w1, WORD_ID w2);
LOGPROB class_tri_prob_rl(NGRAM_INFO *ndata, WORD_ID w1, WORD_ID w2, WORD_ID w3);
#endif
#else  /* USE_DFA */
boolean can_succeed(WCHMM_INFO *wchmm, WORD_ID lastword, int node);
#endif

/* beam.c */
void get_back_trellis_init(HTK_Param *param, WCHMM_INFO *wchmm, BACKTRELLIS *backtrellis);
boolean get_back_trellis_proceed(int t, HTK_Param *param, WCHMM_INFO *wchmm, BACKTRELLIS *backtrellis, boolean final);
void get_back_trellis_end(HTK_Param *param, WCHMM_INFO *wchmm, BACKTRELLIS *backtrellis);
void get_back_trellis(HTK_Param *param, WCHMM_INFO *wchmm, BACKTRELLIS *backtrellis, LOGPROB *backmax);
LOGPROB finalize_1st_pass(BACKTRELLIS *backtrellis, WORD_INFO *winfo, int len);
#ifdef SP_BREAK_CURRENT_FRAME
void finalize_segment(BACKTRELLIS *backtrellis, HTK_Param *param, int len);
#endif

/* outprob_style.c */
#ifdef PASS1_IWCD
void outprob_style_cache_init(WCHMM_INFO *wchmm);
#ifdef CATEGORY_TREE
CD_Set *lcdset_register_with_category(HTK_HMM_INFO *hmminfo, DFA_INFO *dfa, HMM_Logical *hmm, WORD_ID category);
CD_Set *lcdset_lookup_with_category(HTK_HMM_INFO *hmminfo, HMM_Logical *hmm, WORD_ID category);
void lcdset_register_with_category_all(HTK_HMM_INFO *hmminfo, WORD_INFO *winfo, DFA_INFO *dfa);
#endif
#endif
LOGPROB outprob_style(WCHMM_INFO *wchmm, int node, int last_wid, int t, HTK_Param *param);
void error_missing_right_triphone(HMM_Logical *base, char *rc_name);
void error_missing_left_triphone(HMM_Logical *base, char *lc_name);

/* ngram_decode.c */
#include "search.h"
#ifdef USE_NGRAM
int ngram_firstwords(NEXTWORD **nw, int peseqlen, int maxnw, WORD_INFO *winfo, BACKTRELLIS *bt);
int ngram_nextwords(NODE *hypo, NEXTWORD **nw, int maxnw, NGRAM_INFO *ngram, WORD_INFO *winfo, BACKTRELLIS *bt);
boolean ngram_acceptable(NODE *hypo, WORD_INFO *winfo);
#else  /* USE_DFA */
int dfa_firstwords(NEXTWORD **nw, int peseqlen, int maxnw, DFA_INFO *dfa);
int dfa_nextwords(NODE *hypo, NEXTWORD **nw, int maxnw, DFA_INFO *dfa);
boolean dfa_acceptable(NODE *hypo, DFA_INFO *dfa);
boolean dfa_look_around(NEXTWORD *nword, NODE *hypo, BACKTRELLIS *bt);
#endif

/* search_bestfirst_main.c */
#ifdef SCAN_BEAM
void envl_init(int framenum);
#endif
void putsentence(NODE *hypo, int num);
/* void wchmm_fbs(HTK_Param *param, BACKTRELLIS *backtrellis, LOGPROB backmax, int stacksize, int ncan, int maxhypo, int (*gm_get_first_words)(NEXTWORD **, int, int), int (*gm_get_next_words)(NODE *, NEXTWORD **, int), boolean (*gm_acceptable)(NODE *), LOGPROB (*gm_get_eos_score)(NODE *)); */
void wchmm_fbs(HTK_Param *param, BACKTRELLIS *backtrellis, LOGPROB backmax, int stacksize, int ncan, int maxhypo);

/* search_bestfirst_v?.c */
void free_node(NODE *node);
NODE *cpy_node(NODE *dst, NODE *src);
NODE *newnode();
void malloc_wordtrellis();
void free_wordtrellis();
void scan_word(NODE *now, HTK_Param *param);
void next_word(NODE *now, NODE *new, NEXTWORD *nword, HTK_Param *param, BACKTRELLIS *backtrellis);
void start_word(NODE *new, NEXTWORD *nword, HTK_Param *param, BACKTRELLIS *backtrellis);
void last_next_word(NODE *now, NODE *new, HTK_Param *param);

/* wav2mfcc.c */
HTK_Param *new_wav2mfcc(SP16 speech[], int speechlen);

/* version.c */
void put_header(FILE *stream);
void put_compile_defs(FILE *stream);

/* wchmm.c */
void print_wchmm_info(WCHMM_INFO *wchmm);
#ifdef CATEGORY_TREE
void build_wchmm(WCHMM_INFO *wchmm);
#endif
void build_wchmm2(WCHMM_INFO *wchmm);

/* wchmm_check.c */
void wchmm_check_interactive(WCHMM_INFO *wchmm);
void check_wchmm(WCHMM_INFO *wchmm);

/* realtime.c --- callback for adin_cut() */
void RealTimeInit();
void RealTimePipeLinePrepare();
int RealTimePipeLine(SP16 *Speech, int len);
int RealTimeResume();
HTK_Param *RealTimeParam(LOGPROB *backmax);

/* word_align.c */
void word_align(WORD_ID *words, short wnum, HTK_Param *param);
void phoneme_align(WORD_ID *words, short wnum, HTK_Param *param);
void state_align(WORD_ID *words, short wnum, HTK_Param *param);
void word_rev_align(WORD_ID *revwords, short wnum, HTK_Param *param);
void phoneme_rev_align(WORD_ID *revwords, short wnum, HTK_Param *param);
void state_rev_align(WORD_ID *revwords, short wnum, HTK_Param *param);

/* main.c */
char *get_line(char *prompt);
#ifdef WORD_GRAPH
void verify_WORD_GRAPH_define();
#else
void verify_WORD_GRAPH_undefine();
#endif
#ifdef WPAIR
void verify_WPAIR_define();
#else
void verify_WPAIR_undefine();
#endif
void check_specs();	/* check needed parameter */
void print_setting();		/* output current setting */
void print_info();		/* output current gammar info */
/* m_usage.c */
void opt_terminate();
void usage();
void detailed_help();
/* m_options.c */
void opt_parse(int argc, char *argv[], char *cwd);
/* m_jconf.c */
void config_file_parse(char *conffile);
/* m_chkparam.c */
void check_specs();
void set_beam_width();
void set_lm_weight();
void set_lm_weight2();
/* m_info.c */
void print_setting();
void print_info();
/* m_bootup.c */
void system_bootup();
/* m_adin.c */
void adin_initialize();
/* m_fusion.c */
void final_fusion();
/* result_tty.c */
void setup_result_tty();
/* result_msock.c */
void setup_result_msock();
void decode_output_selection(char *str);
void msock_status_recready();
void msock_status_recstart();
void msock_status_recend();

/* hmm_check.c */
void hmm_check(HTK_HMM_INFO *hmminfo, WORD_INFO *winfo);

/* record.c */
void record_sample_open();
void record_sample_write(SP16 *speech, int samplenum);
void record_sample_close();

/* main.c */
void main_recognition_loop();
