/*
 * Decompiled with CFR 0.152.
 */
package junkutil.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import junkutil.common.StringUtil;

public class LzList {
    private List base;
    private Comparator compStrAsc = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private Comparator compStrDesc = new Comparator(){

        public int compare(Object o1, Object o2) {
            return -o1.toString().compareTo(o2.toString());
        }
    };

    public LzList() {
        this.base = new ArrayList();
    }

    public LzList(List list) {
        this.base = list;
    }

    public LzList(Object[] args) {
        this.base = Arrays.asList(args);
    }

    public LzList(Set set) {
        this.base = Arrays.asList(set.toArray());
    }

    public List list() {
        return this.base;
    }

    public LzList or(List arg) {
        ArrayList list = new ArrayList(this.base);
        for (int i = 0; i < arg.size(); ++i) {
            if (this.base.contains(arg.get(i))) continue;
            list.add(arg.get(i));
        }
        return new LzList(list);
    }

    public LzList and(List arg) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < arg.size(); ++i) {
            if (!this.base.contains(arg.get(i))) continue;
            list.add(arg.get(i));
        }
        return new LzList(list);
    }

    public LzList sortAsc() {
        return this.sort(this.compStrAsc);
    }

    public LzList sortDesc() {
        return this.sort(this.compStrDesc);
    }

    public LzList sort(Comparator c) {
        ArrayList list = new ArrayList(this.base);
        Collections.sort(list, c);
        return new LzList(list);
    }

    public LzList grep(String re) {
        ArrayList list = new ArrayList();
        Pattern pattern = Pattern.compile(re);
        for (int i = 0; i < this.base.size(); ++i) {
            Object obj = this.base.get(i);
            if (obj == null || !StringUtil.match(obj.toString(), pattern)) continue;
            list.add(obj);
        }
        return new LzList(list);
    }

    public LzList ungrep(String re) {
        ArrayList list = new ArrayList();
        Pattern pattern = Pattern.compile(re);
        for (int i = 0; i < this.base.size(); ++i) {
            Object obj = this.base.get(i);
            if (obj == null || StringUtil.match(obj.toString(), pattern)) continue;
            list.add(obj);
        }
        return new LzList(list);
    }

    public LzList join(List arg) {
        ArrayList list = new ArrayList(this.base);
        Iterator i = arg.iterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return new LzList(list);
    }

    public LzList uniq() {
        HashMap map = new HashMap();
        for (int i = 0; i < this.base.size(); ++i) {
            map.put(this.base.get(i), Object.class);
        }
        return new LzList(new ArrayList(map.keySet()));
    }

    public boolean equals(List arg) {
        if (this.base.size() != arg.size()) {
            return false;
        }
        for (int i = 0; i < this.base.size(); ++i) {
            Object obj2;
            Object obj1 = this.base.get(i);
            if (obj1.equals(obj2 = arg.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsOnSort(List arg) {
        if (this.base.size() != arg.size()) {
            return false;
        }
        LzList sortedBase = new LzList(this.base).sortAsc();
        List sortedArg = new LzList(arg).sortAsc().list();
        return this.equals(arg);
    }

    public boolean equals(String arg) {
        return this.toString().equals(arg);
    }

    public String toString() {
        return this.base.toString();
    }
}

