package junkutil.crypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * MD5̃`FbNT擾NXB
 * ̃NXJunkUtil̑̃NXɈˑ܂B
 * @author Hiroyuki Shiota
 */
public class MD5 {
	public static final String MD2 = "MD2";
	public static final String MD5 = "MD5";
	public static final String SHA = "SHA";
	public static final String SHA_1 = "SHA-1";
	public static final String SHA_256 = "SHA-256";
	public static final String SHA_384 = "SHA-384";
	public static final String SHA_512 = "SHA-512";
	
	/**
	 * ftHg̃ASYB
	 */
	private String algorithm = MD5;
	
	/**
	 * RXgN^B
	 */
	public MD5() {
	}
	
	/**
	 * ASYw肷RXgN^B
	 * @param algorithm
	 */
	public MD5(String algorithm) {
		this.algorithm = algorithm;
	}
	
	/**
	 * ̃`FbNT߂B
	 */
	public String crypt(String str) throws NoSuchAlgorithmException {
		if (str == null || str.length() == 0) {
			throw new IllegalArgumentException("str is null.");
		}
		return crypt(str.getBytes());
	}
	
	/**
	 * w̃GR[fBOł̃̕`FbNT߂B
	 */
	public String crypt(String str, String encoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
		if (str == null || str.length() == 0) {
			throw new IllegalArgumentException("str is null.");
		}
		if (encoding == null) {
			throw new IllegalArgumentException("encoding is null.");
		}
		return crypt(str.getBytes(encoding));
	}
	
	/**
	 * byte[]̃`FbNT߂B
	 */
	public String crypt(byte [] bytes) throws NoSuchAlgorithmException {
		if (bytes == null || bytes.length == 0) {
			throw new IllegalArgumentException("bytes is null");
		}
		MessageDigest digest = MessageDigest.getInstance(algorithm);
		byte[] hash = digest.digest(bytes);
		return hash2hex(hash);
	}
	
	/**
	 * t@CȂǂ̃`FbNT߂B
	 */
	public String crypt(InputStream in, int buffSize) throws NoSuchAlgorithmException, IOException {
		if (in == null || in.available() == 0) {
			throw new IllegalArgumentException("InputStream is null.");
		}
		MessageDigest digest = MessageDigest.getInstance(algorithm);
		try {
			byte[] buff = new byte[buffSize];
			int len = 0;
			while ((len = in.read(buff, 0, buff.length)) >= 0) {
				digest.update(buff, 0, len);
			}
		} catch (IOException e) {
			throw e;
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e) {
				}
			}
		}
		byte[] hash = digest.digest();
		return hash2hex(hash);
	}
	
	/**
	 * oCg16iɕϊB
	 */
	private static String hash2hex(byte []hash) {
		StringBuffer hexString = new StringBuffer();
		for (int i = 0; i < hash.length; i++) {
			if ((0xff & hash[i]) < 0x10) {
				hexString.append("0" + Integer.toHexString((0xFF & hash[i])));
			} else {
				hexString.append(Integer.toHexString(0xFF & hash[i]));
			}
		}
		
		return new String(hexString);
	}
}
