/*
 * Decompiled with CFR 0.152.
 */
package junkutil.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junkutil.set.LzList;

public class DataDumper {
    private DataDumper() {
    }

    public static void dumpMap(PrintStream out, Map map) {
        DataDumper.dumpMap(new PrintWriter(out), map);
    }

    public static void dumpMap(PrintWriter out, Map map) {
        List keys = new LzList(map.keySet()).sortAsc().list();
        for (String key : keys) {
            Object value = map.get(key);
            out.println(key + "=" + value.toString());
        }
        out.flush();
    }

    public static void dumpList(PrintStream out, List list) {
        DataDumper.dumpList(new PrintWriter(out), list);
    }

    public static void dumpList(PrintWriter out, List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            out.println(obj.toString());
        }
        out.flush();
    }

    public static void dumpByteArray(PrintStream out, byte[] byteArray) {
        DataDumper.dumpByteArray(new PrintWriter(out), byteArray);
    }

    public static void dumpByteArray(PrintWriter out, byte[] byteArray) {
        int no = 0;
        block0: for (int i = 0; i < byteArray.length; ++i) {
            for (int j = 0; j < 16; ++j) {
                String hex;
                if (i * 16 + j >= byteArray.length) break block0;
                if (j == 0) {
                    hex = Integer.toHexString(no).toUpperCase();
                    out.print("0000".substring(0, 4 - hex.length()) + hex + ":");
                    no += 16;
                }
                if (j == 8) {
                    out.print("  ");
                }
                hex = Integer.toHexString(0xFF & byteArray[i * 16 + j]).toUpperCase();
                out.print(" " + (hex.length() == 1 ? "0" : "") + hex);
            }
            out.println();
        }
        out.println();
        out.flush();
    }

    public static void dumpStrings(PrintStream out, String[] strings) {
        DataDumper.dumpStrings(new PrintWriter(out), strings);
    }

    public static void dumpStrings(PrintWriter out, String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            out.println(strings[i]);
        }
        out.flush();
    }

    public static void dumpString(PrintStream out, String string) {
        DataDumper.dumpString(new PrintWriter(out), string);
    }

    public static void dumpString(PrintWriter out, String string) {
        out.println(string);
        out.flush();
    }

    public static void dumpException(PrintStream out, Throwable t) {
        DataDumper.dumpException(new PrintWriter(out), t);
    }

    public static void dumpException(PrintWriter out, Throwable t) {
        out.println(DataDumper.exceptionToString(t));
        out.flush();
    }

    public static String exceptionToString(Throwable t) {
        if (t == null) {
            return "null";
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bout);
        t.printStackTrace(out);
        return bout.toString();
    }

    public static void dumpBean(PrintWriter out, Object obj) {
        DataDumper.dumpBean(DataDumper.wrap(out), obj);
    }

    public static void dumpBean(PrintStream out, Object obj) {
        if (out == null) {
            out = System.out;
        }
        if (obj == null) {
            throw new NullPointerException("obj is null.");
        }
        Class<?> objClass = obj.getClass();
        out.println("[" + objClass.getName() + "] Dump Start");
        Method[] methods = objClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            String returnTypeStr = DataDumper.getClassName(returnType);
            Class<?>[] params = method.getParameterTypes();
            if (returnTypeStr.equals("void") || returnTypeStr.equals("java.lang.Class") || !methodName.startsWith("get") || params.length > 0) continue;
            out.print(methodName + "()=");
            List<Object> rtObj = null;
            String rtObjStr = null;
            try {
                rtObj = method.invoke(obj, new Object[0]);
                if (rtObj != null && rtObj.getClass().isArray()) {
                    int j;
                    Comparable<Boolean>[] wa;
                    Object[] pa;
                    if (rtObj instanceof boolean[]) {
                        pa = (boolean[])rtObj;
                        wa = new Boolean[pa.length];
                        for (j = 0; j < pa.length; ++j) {
                            wa[j] = pa[j];
                        }
                        rtObj = Arrays.asList(wa);
                    } else if (rtObj instanceof byte[]) {
                        pa = (byte[])rtObj;
                        wa = new Byte[pa.length];
                        for (j = 0; j < pa.length; ++j) {
                            wa[j] = pa[j];
                        }
                        rtObj = Arrays.asList(wa);
                    } else if (rtObj instanceof int[]) {
                        pa = (int[])rtObj;
                        wa = new Integer[pa.length];
                        for (j = 0; j < pa.length; ++j) {
                            wa[j] = pa[j];
                        }
                        rtObj = Arrays.asList(wa);
                    } else if (rtObj instanceof float[]) {
                        pa = (float[])rtObj;
                        wa = new Float[pa.length];
                        for (j = 0; j < pa.length; ++j) {
                            wa[j] = Float.valueOf((float)pa[j]);
                        }
                        rtObj = Arrays.asList(wa);
                    } else if (rtObj instanceof double[]) {
                        pa = (double[])rtObj;
                        wa = new Double[pa.length];
                        for (j = 0; j < pa.length; ++j) {
                            wa[j] = (double)pa[j];
                        }
                        rtObj = Arrays.asList(wa);
                    } else {
                        rtObj = Arrays.asList((Object[])rtObj);
                    }
                }
                rtObjStr = rtObj == null ? "null" : rtObj.toString();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    out.println("(exception):" + e.getCause().getMessage() + " " + returnTypeStr);
                    continue;
                }
                out.println("(exception):" + e.getMessage() + " " + returnTypeStr);
                continue;
            }
            catch (IllegalAccessException e) {
                if (e.getCause() != null) {
                    out.println("(exception):" + e.getCause().getMessage() + " " + returnTypeStr);
                    continue;
                }
                out.println("(exception):" + e.getMessage() + " " + returnTypeStr);
                continue;
            }
            if (rtObjStr == null) {
                rtObjStr = "null";
            }
            out.println(rtObjStr + " " + returnTypeStr);
        }
        out.println("[" + objClass.getName() + "] Dump End");
        out.flush();
    }

    private static String getClassName(Class argClass) {
        if (argClass.isArray()) {
            if (argClass == boolean[].class) {
                return "boolean[]";
            }
            if (argClass == byte[].class) {
                return "byte[]";
            }
            if (argClass == int[].class) {
                return "int[]";
            }
            if (argClass == float[].class) {
                return "float[]";
            }
            if (argClass == double[].class) {
                return "double[]";
            }
            return argClass.getName().replaceAll("^\\[L|;", "") + "[]";
        }
        return argClass.getName();
    }

    public static PrintWriter wrap(Writer jw) {
        return new PrintWriter(jw);
    }
}

