/*
 * Decompiled with CFR 0.152.
 */
package junkutil.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import junkutil.common.StringUtil;
import junkutil.set.LzListClosure;

public class LzList {
    private List base;
    private static Comparator compStrAsc = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private static Comparator compStrDesc = new Comparator(){

        public int compare(Object o1, Object o2) {
            return -o1.toString().compareTo(o2.toString());
        }
    };

    public LzList() {
        this.base = new ArrayList();
    }

    public LzList(List list) {
        this.base = list;
    }

    public LzList(Object[] args) {
        this.base = Arrays.asList(args);
    }

    public LzList(Set set) {
        this.base = Arrays.asList(set.toArray());
    }

    public LzList(Enumeration e) {
        this.base = LzList.asList(e);
    }

    public LzList(Iterator i) {
        this.base = LzList.asList(i);
    }

    public List list() {
        return this.base;
    }

    public LzList or(List arg) {
        ArrayList list = new ArrayList(this.base);
        for (int i = 0; i < arg.size(); ++i) {
            Object obj = arg.get(i);
            if (this.base.contains(obj)) continue;
            list.add(obj);
        }
        return new LzList(list);
    }

    public LzList and(List arg) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < arg.size(); ++i) {
            Object obj = arg.get(i);
            if (!this.base.contains(obj)) continue;
            list.add(obj);
        }
        return new LzList(list);
    }

    public LzList notNull() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.base.size(); ++i) {
            Object obj = this.base.get(i);
            if (obj == null) continue;
            list.add(obj);
        }
        return new LzList(list);
    }

    public LzList sortAsc() {
        return this.sort(compStrAsc);
    }

    public LzList sortDesc() {
        return this.sort(compStrDesc);
    }

    public LzList sort(Comparator c) {
        ArrayList list = new ArrayList(this.base);
        Collections.sort(list, c);
        return new LzList(list);
    }

    public LzList grep(String re) {
        ArrayList list = new ArrayList();
        Pattern pattern = Pattern.compile(re);
        for (int i = 0; i < this.base.size(); ++i) {
            Object obj = this.base.get(i);
            if (obj == null || !StringUtil.match(obj.toString(), pattern)) continue;
            list.add(obj);
        }
        return new LzList(list);
    }

    public LzList ungrep(String re) {
        ArrayList list = new ArrayList();
        Pattern pattern = Pattern.compile(re);
        for (int i = 0; i < this.base.size(); ++i) {
            Object obj = this.base.get(i);
            if (obj == null || StringUtil.match(obj.toString(), pattern)) continue;
            list.add(obj);
        }
        return new LzList(list);
    }

    public LzList join(Collection arg) {
        ArrayList list = new ArrayList(this.base);
        list.addAll(arg);
        return new LzList(list);
    }

    public LzList uniq() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.base.size(); ++i) {
            Object obj = this.base.get(i);
            if (list.contains(obj)) continue;
            list.add(obj);
        }
        return new LzList(list);
    }

    public LzList reverse() {
        ArrayList list = new ArrayList();
        int len = this.base.size();
        for (int i = len - 1; i >= 0; --i) {
            list.add(this.base.get(i));
        }
        return new LzList(list);
    }

    public LzList forEach(LzListClosure closure) {
        ArrayList list = new ArrayList();
        int len = this.base.size();
        for (int i = 0; i < len; ++i) {
            Object obj = this.base.get(i);
            if (!closure.process(i, len, obj)) continue;
            list.add(obj);
        }
        return new LzList(list);
    }

    public boolean equals(List arg) {
        if (this.base == arg) {
            return true;
        }
        if (this.base.size() != arg.size()) {
            return false;
        }
        for (int i = 0; i < this.base.size(); ++i) {
            Object obj1 = this.base.get(i);
            Object obj2 = arg.get(i);
            if (obj1 == null && obj2 == null) continue;
            if (obj1 == null || obj2 == null) {
                return false;
            }
            if (obj1.equals(obj2)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsOnSort(List arg) {
        if (this.base.size() != arg.size()) {
            return false;
        }
        LzList sortedBase = new LzList(this.base).sortAsc();
        List sortedArg = new LzList(arg).sortAsc().list();
        return sortedBase.equals(sortedArg);
    }

    public boolean equals(String arg) {
        return this.toString().equals(arg);
    }

    public String toString() {
        return this.base.toString();
    }

    public static List asList(Enumeration e) {
        ArrayList result = new ArrayList();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result;
    }

    public static List asList(Iterator i) {
        ArrayList result = new ArrayList();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }
}

