package junkutil.excel;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/**
 * Excel𑀍삷
 * @author Hiroyuki Shiota
 */
public class ExcelUtil {
	HSSFWorkbook workbook;
	HSSFSheet sheet;
	HSSFCellStyle style;
	HSSFFont selectedFont;
	String fontName;
	int fontSize;

	/**
	 * RXgN^
	 */
	public ExcelUtil() {
		fontName = "lr SVbN";
		fontSize = 11;
	}

	/**
	 * ftHg̃tHgwłRXgN^
	 * @param fontName
	 * @param size
	 */
	public ExcelUtil(String fontName, int fontSize) {
		this.fontName = fontName;
		this.fontSize = fontSize;
	}

	/**
	 * J
	 */
	public void free() {
		workbook = null;
		sheet = null;
		style = null;
		selectedFont = null;
		fontName = null;
	}

	/**
	 * ubN쐬
	 */
	public void create() {
		workbook = new HSSFWorkbook();
		initFont();
		setFont(fontName, fontSize);
	}

	/**
	 * Excelt@Cǂݍ
	 * @param file
	 * @throws IOException
	 */
	public void read(File file) throws IOException {
		BufferedInputStream bufInput = null;
		try {
			// ev[gExcelt@Cǂݍ
			bufInput = new BufferedInputStream(new FileInputStream(file));
			POIFSFileSystem fileSys = new POIFSFileSystem(bufInput);
			// [NubN̍쐬
			workbook = new HSSFWorkbook(fileSys);
			initFont();
			setFont(fontName, fontSize);
			if (getNumberOfSheets() > 0) selectSheet(0);
		} catch (IOException e) {
			throw e;
		} finally {
			try {
				if (bufInput != null) bufInput.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * Excelt@Co
	 * @param file
	 * @throws IOException
	 */
	public void write(File file) throws IOException {
		BufferedOutputStream bufOutput = null;
		try {
			bufOutput = new BufferedOutputStream(new FileOutputStream(file));
			// [NubN̏o
			workbook.write(bufOutput);
			bufOutput.flush();
			bufOutput.close();
		} catch (IOException e) {
			throw e;
		} finally {
			try {
				if (bufOutput != null) bufOutput.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * [NubN擾
	 * @return
	 */
	public HSSFWorkbook getWorkbook() {
		return workbook;
	}

	/**
	 * V[g擾
	 * @return
	 */
	public HSSFSheet getSheet() {
		return sheet;
	}

	/**
	 * V[gI
	 * @param i
	 */
	public void selectSheet(int i) {
		sheet = workbook.getSheetAt(i);
	}

	/**
	 * V[gI
	 * @param i
	 */
	public void selectSheet(String name) {
		sheet = workbook.getSheet(name);
	}

	/**
	 * V[g쐬
	 * @param name
	 * @return
	 */
	public int createSheet(String name) {
		workbook.createSheet(name);
		return getNumberOfSheets()-1;
	}

	/**
	 * V[gI
	 * @param name
	 * @return
	 */
	public int createSheetAndSelect(String name) {
		workbook.createSheet(name);
		int sheetNo = getNumberOfSheets()-1;
		selectSheet(sheetNo);
		return sheetNo;
	}

	/**
	 * V[g폜
	 * @param i
	 */
	public void removeSheet(int i) {
		workbook.removeSheetAt(i);
	}

	/**
	 * V[gԂ
	 * @return
	 */
	public int getNumberOfSheets() {
		return workbook.getNumberOfSheets();
	}

	/**
	 * Z̒lZbgij
	 * @param iRow
	 * @param iCol
	 * @param intVal
	 */
	public void setCellString(int iRow, int iCol, String strVal) {
		if (sheet == null) {
			throw new NullPointerException("Sheet is null");
		}
		HSSFCell cell = getCell(sheet, iRow, iCol);
		//cell.setEncoding(HSSFCell.ENCODING_UTF_16);
		cell.setCellValue(strVal);
		setCellFont(cell);
	}

	/**
	 * Z̒lZbgilj
	 * @param iRow
	 * @param iCol
	 * @param intVal
	 */
	public void setCellNumeric(int iRow, int iCol, double intVal) {
		if (sheet == null) {
			throw new NullPointerException("Sheet is null");
		}
		HSSFCell cell = getCell(sheet, iRow, iCol);
		//cell.setEncoding(HSSFCell.ENCODING_UTF_16);
		cell.setCellValue(intVal);
		setCellFont(cell);
	}

	/**
	 * Z̒l擾ij
	 * @param iRow
	 * @param iCol
	 * @return
	 */
	public String getCellString(int iRow, int iCol) {
		if (sheet == null) {
			throw new NullPointerException("Sheet is null");
		}
		HSSFCell cell = getCell(sheet, iRow, iCol);
		return cell.getStringCellValue();
	}

	/**
	 * Z̒l擾ilj
	 * @param iRow
	 * @param iCol
	 * @return
	 */
	public double getCellNumeric(int iRow, int iCol) {
		if (sheet == null) {
			throw new NullPointerException("Sheet is null");
		}
		HSSFCell cell = getCell(sheet, iRow, iCol);
		return cell.getNumericCellValue();
	}

	/**
	 * ZIuWFNg擾
	 * @param sheet
	 * @param iRow
	 * @param iCol
	 * @return
	 */
	public HSSFCell getCell(HSSFSheet sheet, int iRow, int iCol) {
		HSSFRow row = sheet.getRow(iRow);
		if (row == null) {
			row = sheet.createRow((short)iRow);
		}
		HSSFCell cell = row.getCell(iCol);
		if (cell == null) {
			cell = row.createCell(iCol);
		}
		return cell;
	}

	/**
	 * ZIuWFNg擾
	 * @param sheet
	 * @param iRow
	 * @param iCol
	 * @return
	 */
	public HSSFCell getCellOrNull(HSSFSheet sheet, int iRow, int iCol) {
		HSSFRow row = sheet.getRow(iRow);
		if (row == null) return null;
		HSSFCell cell = row.getCell(iCol);
		return cell;
	}

	/**
	 * Z̃tHgݒ肷
	 * @param cell
	 */
	public void setCellFont(HSSFCell cell) {
		HSSFCellStyle style = cell.getCellStyle();
		if (style != null) {
			style.setFont(selectedFont);
		} else {
			style = this.style;
			cell.setCellStyle(style);
		}
	}

	/**
	 * tHg̏܂B
	 */
	public void initFont() {
		for (int i = 0; i < workbook.getNumberOfFonts(); i++) {
			HSSFFont font = workbook.getFontAt((short)i);
			font.setFontName(fontName);
			font.setFontHeightInPoints((short)fontSize);
		}
	}

	/**
	 * tHgݒ肵܂B
	 * @param fontName
	 * @param size
	 */
	public void setFont(String fontName, int size) {
		selectedFont = workbook.createFont();
		selectedFont.setFontName(fontName);
		selectedFont.setFontHeightInPoints((short)size);
		style = workbook.createCellStyle();
		style.setFont(selectedFont);
	}

}
