/*
 * Decompiled with CFR 0.152.
 */
package junkutil.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junkutil.common.DataDumper;
import junkutil.common.StringUtil;

public class Config {
    public static final String USE_ENCODING_ENTRY = "USE_ENCODING_ENTRY";
    private static final String ENCODING_ENTRY = "encoding";
    private static String[] lineCommentsSetting = new String[]{"#", "//", ";"};
    private static String sectionDelimiter = ".";

    private Config() {
    }

    public static String[] getLineCommentsSetting() {
        return lineCommentsSetting;
    }

    public static void setLineCommentsSetting(String[] iniLineComments) {
        lineCommentsSetting = iniLineComments;
    }

    public static String getSectionDelimiter() {
        return sectionDelimiter;
    }

    public static void setSectionDelimiter(String delim) {
        sectionDelimiter = delim;
    }

    public static Map readProperties(String filename) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties p = new Properties();
        if (!new File(filename).exists()) {
            return null;
        }
        try {
            p.load(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result.put(key, p.getProperty(key));
        }
        return result;
    }

    public static Map readIniFile(String filename) throws IOException {
        return Config.readIniFile(filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readIniFile(String filename, String encoding) throws IOException {
        if (encoding != null && encoding.equals(USE_ENCODING_ENTRY)) {
            Map asciiMap = Config.readIniFile(filename, null);
            if (asciiMap == null) {
                return null;
            }
            if (asciiMap.containsKey(ENCODING_ENTRY)) {
                encoding = (String)asciiMap.get(ENCODING_ENTRY);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (!new File(filename).exists()) {
            return null;
        }
        BufferedReader buffReader = null;
        InputStreamReader inputReader = null;
        FileInputStream inputStream = null;
        try {
            inputReader = encoding != null ? new InputStreamReader((InputStream)new FileInputStream(filename), encoding) : new InputStreamReader(new FileInputStream(filename));
            buffReader = new BufferedReader(inputReader);
            String section = null;
            String line = null;
            block5: while ((line = buffReader.readLine()) != null) {
                String lineTrim = line.replace('\t', ' ').trim();
                if (lineTrim.length() == 0) continue;
                for (int i = 0; i < lineCommentsSetting.length; ++i) {
                    if (lineTrim.startsWith(lineCommentsSetting[i])) continue block5;
                }
                String[] tokens = line.split("=");
                String key = tokens[0].replace('\t', ' ').trim();
                String value = null;
                if (tokens.length == 1) {
                    if (key.startsWith("[") && key.endsWith("]")) {
                        section = StringUtil.unwrapBracket(key, "[", "]");
                        continue;
                    }
                    value = "";
                } else if (tokens.length == 2) {
                    value = tokens[1];
                } else {
                    StringBuffer sb = new StringBuffer(tokens[1]);
                    for (int i = 2; i < tokens.length; ++i) {
                        sb.append("=");
                        sb.append(tokens[i]);
                    }
                    value = new String(sb);
                }
                if (section != null) {
                    key = section + sectionDelimiter + key;
                }
                result.put(key, value);
            }
        }
        catch (FileNotFoundException e) {
            Map map = null;
            return map;
        }
        finally {
            if (buffReader != null) {
                buffReader.close();
            }
            if (inputReader != null) {
                inputReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeIniFile(String filename, Map ini, String encoding) throws IOException {
        PrintWriter printWriter = null;
        OutputStreamWriter outputWriter = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(filename);
            outputWriter = encoding != null ? new OutputStreamWriter((OutputStream)outputStream, encoding) : new OutputStreamWriter(outputStream);
            printWriter = new PrintWriter(outputWriter);
            DataDumper.dumpMap(printWriter, ini);
            printWriter.flush();
            outputWriter.flush();
            outputStream.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (outputWriter != null) {
                outputWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return 0;
    }

    public static Map getSystemProperties() {
        ArrayList<Object> envKeys = Collections.list(System.getProperties().keys());
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : envKeys) {
            String value = System.getProperty(string);
            result.put(string, value);
        }
        return result;
    }
}

