package junkutil.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

/**
 * Œ蒷̃eLXg̓tB[h
 * @author Hiroyuki Shiota
 */
public class LzFixedTextField  extends JTextField {

	private int maxLength = -1;

	/**
	 * ͉\񒷂擾
	 * @return
	 */
	public int getMaxLength() {
		return maxLength;
	}

	/**
	 * ͉\񒷂ݒ肷
	 * @param arg
	 */
	public void setMaxLength(int arg) {
		maxLength = arg;
	}

	/**
	 * RXgN^
	 * @param cols
	 */
	public LzFixedTextField(int cols) {
		super(cols);
	}

	/**
	 * RXgN^
	 * @param cols
	 * @param maxLength
	 */
	public LzFixedTextField(int cols, int maxLength) {
		super(cols);
		this.maxLength = maxLength;
	}

	protected Document createDefaultModel() {
		return new LzFixedTextDocument();
	}

	private class LzFixedTextDocument extends PlainDocument {
		public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
			if (str == null) {
				return;
			}
			if(maxLength != -1 && maxLength < (getLength()+str.length())) {
				str=str.substring(0, maxLength-getLength());
			}
			super.insertString(offs, str, a);
		}
	}
}