/*
 * Decompiled with CFR 0.152.
 */
package junkutil.common;

import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private DateUtil() {
    }

    public static String dateDiff(Date date) {
        return DateUtil.dateDiff(Calendar.getInstance().getTime(), date);
    }

    public static String dateDiff(Date now, Date date) {
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(now);
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        long diffTime = nowCal.getTimeInMillis() - dateCal.getTimeInMillis();
        if (diffTime < 0L) {
            return "0\u79d2\u524d";
        }
        long second = diffTime / 1000L;
        if (second < 60L) {
            return second + "\u79d2\u524d";
        }
        long minute = second / 60L;
        if (minute < 60L) {
            return minute + "\u5206\u524d";
        }
        long hour = minute / 60L;
        if (hour < 24L) {
            return hour + "\u6642\u9593\u524d";
        }
        long day = hour / 24L;
        if (day <= 28L) {
            return day + "\u65e5\u524d";
        }
        dateCal.add(2, 1);
        if (dateCal.after(nowCal)) {
            return day + "\u65e5\u524d";
        }
        dateCal.setTime(date);
        dateCal.add(2, 12);
        if (dateCal.after(nowCal)) {
            for (int i = 11; i >= 1; --i) {
                dateCal.setTime(date);
                dateCal.add(2, i);
                if (!dateCal.before(nowCal)) continue;
                return i + "\u30f6\u6708\u524d";
            }
        }
        long year = day / 365L;
        return year + "\u5e74\u524d";
    }
}

