/*
 * Decompiled with CFR 0.152.
 */
package junkutil.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LzFixedNumberField
extends JTextField {
    private int maxLength = -1;

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int arg) {
        this.maxLength = arg;
    }

    public LzFixedNumberField(int cols) {
        super(cols);
    }

    public LzFixedNumberField(int cols, int maxLength) {
        super(cols);
        this.maxLength = maxLength;
    }

    @Override
    protected Document createDefaultModel() {
        return new LzFixedNumberDocument();
    }

    class LzFixedNumberDocument
    extends PlainDocument {
        LzFixedNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            str = str.replaceAll("[^\\-+\\.0-9]", "");
            if (LzFixedNumberField.this.maxLength != -1 && LzFixedNumberField.this.maxLength < this.getLength() + str.length()) {
                str = str.substring(0, LzFixedNumberField.this.maxLength - this.getLength());
            }
            super.insertString(offs, str, a);
        }
    }
}

