/*
 * Decompiled with CFR 0.152.
 */
package junkutil.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LzFixedNumberField
extends JTextField {
    private int maxLength = -1;

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int arg) {
        this.maxLength = arg;
    }

    public LzFixedNumberField(int cols) {
        super(cols);
    }

    public LzFixedNumberField(int cols, int maxLength) {
        super(cols);
        this.maxLength = maxLength;
    }

    @Override
    protected Document createDefaultModel() {
        return new LzFixedNumberDocument();
    }

    public boolean isInt() {
        try {
            Integer.parseInt(this.getText());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean isDouble() {
        try {
            Double.parseDouble(this.getText());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.getText());
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    class LzFixedNumberDocument
    extends PlainDocument {
        LzFixedNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            str = str.replaceAll("[^\\-+\\.0-9]", "");
            if (LzFixedNumberField.this.maxLength != -1 && LzFixedNumberField.this.maxLength < this.getLength() + str.length()) {
                str = str.substring(0, LzFixedNumberField.this.maxLength - this.getLength());
            }
            super.insertString(offs, str, a);
        }
    }
}

